/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.PlaceholderResolver;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.zookeeper.utils.InterpolationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;

public abstract class SubstitutionSupport {
    private final Map<String, PlaceholderResolver> placeholderResolvers = new HashMap<String, PlaceholderResolver>();

    public abstract BundleContext getBundleContext();

    public synchronized void bind(PlaceholderResolver resolver) {
        if (resolver != null) {
            this.placeholderResolvers.put(resolver.getScheme(), resolver);
        }
    }

    public synchronized void unbind(PlaceholderResolver resolver) {
        if (resolver != null) {
            this.placeholderResolvers.remove(resolver.getScheme());
        }
    }

    public void setPlaceholderResolvers(List<PlaceholderResolver> resolvers) {
        for (PlaceholderResolver resolver : resolvers) {
            this.bind(resolver);
        }
    }

    public synchronized void substituteConfigurations(final Map<String, Map<String, String>> configs) {
        for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
            final String pid = entry.getKey();
            Map<String, String> props = entry.getValue();
            for (Map.Entry<String, String> e : props.entrySet()) {
                final String key = e.getKey();
                String value = e.getValue();
                props.put(key, InterpolationHelper.substVars((String)value, (String)key, null, props, (InterpolationHelper.SubstitutionCallback)new InterpolationHelper.SubstitutionCallback(){

                    public String getValue(String toSubstitute) {
                        if (toSubstitute != null && toSubstitute.contains(":")) {
                            String scheme = toSubstitute.substring(0, toSubstitute.indexOf(":"));
                            if (SubstitutionSupport.this.placeholderResolvers.containsKey(scheme)) {
                                return ((PlaceholderResolver)SubstitutionSupport.this.placeholderResolvers.get(scheme)).resolve(configs, pid, key, toSubstitute);
                            }
                        }
                        return DataStoreUtils.substituteBundleProperty(toSubstitute, SubstitutionSupport.this.getBundleContext());
                    }
                }));
            }
        }
    }
}

