/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.CamelContext;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="backlog-tracer-stop", description="Stops the Backlog tracer")
public class BacklogTracerStop
extends OsgiCommandSupport {
    @Argument(index=0, name="context", description="The name of the Camel context.", required=true, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        CamelContext camel = this.camelController.getCamelContext(this.context);
        if (camel == null) {
            System.err.println("CamelContext " + this.context + " not found.");
            return null;
        }
        BacklogTracer backlogTracer = BacklogTracer.getBacklogTracer((CamelContext)camel);
        if (backlogTracer == null) {
            backlogTracer = (BacklogTracer)camel.getDefaultBacklogTracer();
        }
        backlogTracer.setEnabled(false);
        backlogTracer.resetTraceCounter();
        backlogTracer.clear();
        System.out.println("BacklogTracer stopped on " + camel.getName());
        return null;
    }
}

