/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

@Command(name="encrypt-message", scope="fabric", description="Encrypts a value using the configured algorithm and master password.")
public class Encrypt
extends FabricCommand {
    private static final String FORMAT = "Encrypting message %s\n Using algorithm %s and password %s\n Result: %s";
    @Option(name="-a", aliases={"--alogrithm"}, description="The algorithm to use. (Defaults to the configured one).")
    private String algorithm;
    @Option(name="-p", aliases={"--password"}, description="The password to use. (Defaults to the configured one).")
    private String password;
    @Argument(index=0, name="message", description="The message to encrypt.")
    private String message;

    protected Object doExecute() throws Exception {
        if (ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0])) == null) {
            System.out.println("No encryption algorithm found in the registry.");
            return null;
        }
        if (ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0])) == null) {
            System.out.println("No encryption master password found in the registry.");
            return null;
        }
        this.algorithm = !Strings.isNullOrBlank(this.algorithm) ? this.algorithm : ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]));
        this.password = this.password != null ? this.password : ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]));
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(this.algorithm);
        encryptor.setPassword(this.password);
        System.out.println(String.format(FORMAT, this.message, this.algorithm, this.password, encryptor.encrypt(this.message)));
        return null;
    }
}

