/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.shell.ShellUtils;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="patch-apply", scope="fabric", description="Apply the given patch to the default version")
public class PatchApply
extends FabricCommand {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Option(name="--version", description="Only apply upgrades for the given version instead of the default one")
    private String version;
    @Option(name="--all-versions", description="Apply patch to all versions instead of the default one")
    private boolean allVersions;
    @Argument
    private URL patch;

    protected Object doExecute() throws Exception {
        List<Version> versions = this.version != null && !this.version.isEmpty() ? Collections.singletonList(this.fabricService.getVersion(this.version)) : (this.allVersions ? Arrays.asList(this.fabricService.getVersions()) : Collections.singletonList(this.fabricService.getDefaultVersion()));
        this.username = this.username != null && !this.username.isEmpty() ? this.username : ShellUtils.retrieveFabricUser(this.session);
        this.password = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        for (Version version : versions) {
            this.fabricService.getPatchService().applyPatch(version, this.patch, this.username, this.password);
        }
        return null;
    }
}

