/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.commands.support.RequirementsListSupport;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;

@Command(name="require-profile-list", scope="fabric", description="Lists the requirements for profiles in the fabric", detailedDescription="classpath:status.txt")
public class RequireProfileList
extends RequirementsListSupport {
    @Override
    protected void printRequirements(PrintStream out, FabricRequirements requirements) {
        out.println(String.format("%-40s %-14s %-14s %s", "[profile]", "[# minimum]", "[# maximum]", "[depends on]"));
        List profileRequirements = requirements.getProfileRequirements();
        for (ProfileRequirements profile : profileRequirements) {
            out.println(String.format("%-40s %-14s %-14s %s", profile.getProfile(), this.getStringOrBlank(profile.getMinimumInstances()), this.getStringOrBlank(profile.getMaximumInstances()), this.getStringOrBlank(profile.getDependentProfiles())));
        }
    }

    protected Object getStringOrBlank(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

