/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.annotation.Export;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.collections.MultiMap;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.libg.generics.Create;
import aQute.libg.tarjan.Tarjan;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer
extends Processor {
    static String version;
    static Pattern versionPattern;
    final Map<String, Map<String, String>> contained = Analyzer.newHashMap();
    final Map<String, Map<String, String>> referred = Analyzer.newHashMap();
    final Map<String, Set<String>> uses = Analyzer.newHashMap();
    Map<String, Clazz> classspace;
    Map<String, Clazz> importedClassesCache = Analyzer.newMap();
    Map<String, Map<String, String>> exports;
    Map<String, Map<String, String>> imports;
    Map<String, Map<String, String>> bundleClasspath;
    final Map<String, Map<String, String>> ignored = Analyzer.newHashMap();
    Jar dot;
    Map<String, Map<String, String>> classpathExports;
    String activator;
    final List<Jar> classpath = this.newList();
    static Properties bndInfo;
    boolean analyzed;
    String bsn;
    String versionPolicyUses;
    String versionPolicyImplemented;
    boolean diagnostics = false;
    SortedSet<Clazz.JAVA> formats = new TreeSet<Clazz.JAVA>();
    private boolean inited;
    boolean firstUse = true;
    static Pattern OBJECT_REFERENCE;
    static Pattern fuzzyVersion;
    static Pattern fuzzyVersionRange;
    static Pattern fuzzyModifier;
    static Pattern nummeric;
    static final String DEFAULT_PROVIDER_POLICY = "${range;[==,=+)}";
    static final String DEFAULT_CONSUMER_POLICY = "${range;[==,+)}";
    static String _classesHelp;

    public Analyzer(Processor parent) {
        super(parent);
    }

    public Analyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManifest(File dirOrJar) throws Exception {
        Analyzer analyzer = new Analyzer();
        try {
            analyzer.setJar(dirOrJar);
            Properties properties = new Properties();
            properties.put("Import-Package", "*");
            properties.put("Export-Package", "*");
            analyzer.setProperties(properties);
            Manifest m = analyzer.calcManifest();
            Properties result = new Properties();
            for (Attributes.Name name : m.getMainAttributes().keySet()) {
                result.put(name.toString(), m.getMainAttributes().getValue(name));
            }
            Properties properties2 = result;
            return properties2;
        }
        finally {
            analyzer.close();
        }
    }

    public void analyze() throws Exception {
        if (!this.analyzed) {
            int n;
            this.analyzed = true;
            this.activator = this.getProperty("Bundle-Activator");
            this.bundleClasspath = this.parseHeader(this.getProperty("Bundle-ClassPath"));
            this.analyzeClasspath();
            this.classspace = this.analyzeBundleClasspath(this.dot, this.bundleClasspath, this.contained, this.referred, this.uses);
            for (AnalyzerPlugin plugin : this.getPlugins(AnalyzerPlugin.class)) {
                if (!(plugin instanceof AnalyzerPlugin)) continue;
                AnalyzerPlugin analyzer = plugin;
                try {
                    boolean reanalyze = analyzer.analyzeJar(this);
                    if (!reanalyze) continue;
                    this.classspace = this.analyzeBundleClasspath(this.dot, this.bundleClasspath, this.contained, this.referred, this.uses);
                }
                catch (Exception e) {
                    this.error("Plugin Analyzer " + analyzer + " throws exception " + e, new Object[0]);
                    e.printStackTrace();
                }
            }
            if (this.activator != null && (n = this.activator.lastIndexOf(46)) > 0) {
                this.referred.put(this.activator.substring(0, n), new LinkedHashMap());
            }
            this.referred.keySet().removeAll(this.contained.keySet());
            if (this.referred.containsKey(".")) {
                this.error("The default package '.' is not permitted by the Import-Package syntax. \n This can be caused by compile errors in Eclipse because Eclipse creates \nvalid class files regardless of compile errors.\nThe following package(s) import from the default package " + this.getUsedBy("."), new Object[0]);
            }
            Map<String, Map<String, String>> exportInstructions = this.parseHeader(this.getProperty("Export-Package"));
            Map<String, Map<String, String>> additionalExportInstructions = this.parseHeader(this.getProperty("-exportcontents"));
            exportInstructions.putAll(additionalExportInstructions);
            Map<String, Map<String, String>> importInstructions = this.parseHeader(this.getImportPackages());
            Map<String, Map<String, String>> dynamicImports = this.parseHeader(this.getProperty("DynamicImport-Package"));
            if (dynamicImports != null) {
                this.referred.keySet().removeAll(dynamicImports.keySet());
            }
            Map<String, Map<String, String>> superfluous = Analyzer.newHashMap();
            for (String instr : exportInstructions.keySet()) {
                if (instr.startsWith("!")) continue;
                superfluous.put(instr, exportInstructions.get(instr));
            }
            this.exports = Analyzer.merge("export-package", exportInstructions, this.contained, superfluous.keySet(), null);
            this.exports.remove(".");
            Iterator<Object> i = superfluous.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String pack = (String)entry.getKey();
                if (Analyzer.isDuplicate(pack)) {
                    i.remove();
                    continue;
                }
                if (!this.isMetaData(pack)) continue;
                this.exports.put(pack, (Map<String, String>)entry.getValue());
                i.remove();
            }
            if (!superfluous.isEmpty()) {
                this.warning("Superfluous export-package instructions: " + superfluous.keySet(), new Object[0]);
            }
            Map<String, Map<String, String>> referredAndExported = this.newMap(this.referred);
            referredAndExported.putAll(this.doExportsToImports(this.exports));
            TreeSet<String> extra = new TreeSet<String>(importInstructions.keySet());
            this.imports = Analyzer.merge("import-package", importInstructions, referredAndExported, extra, this.ignored);
            for (String p : extra) {
                if (p.startsWith("!") || p.indexOf(42) >= 0 || p.indexOf(63) >= 0 || p.indexOf(91) >= 0) {
                    if (this.isResourceOnly() || p.equals("*")) continue;
                    this.warning("Did not find matching referal for " + p, new Object[0]);
                    continue;
                }
                Map<String, String> map = importInstructions.get(p);
                this.imports.put(p, map);
            }
            this.augmentExports();
            this.augmentImports();
            this.doUses(this.exports, this.uses, this.imports);
        }
    }

    Set<Instruction> removeMarkedDuplicates(Collection<Instruction> superfluous) {
        HashSet<Instruction> result = new HashSet<Instruction>();
        for (Instruction instr : superfluous) {
            if (Analyzer.isDuplicate(instr.getPattern()) || instr.isOptional()) continue;
            result.add(instr);
        }
        return result;
    }

    protected String getImportPackages() {
        return this.getProperty("Import-Package");
    }

    boolean isResourceOnly() {
        return Analyzer.isTrue(this.getProperty("-resourceonly"));
    }

    Set<String> getUsedBy(String pack) {
        Set<String> set = this.newSet();
        for (Map.Entry<String, Set<String>> entry : this.uses.entrySet()) {
            Set<String> used = entry.getValue();
            if (!used.contains(pack)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public Manifest calcManifest() throws Exception {
        String exportHeader;
        this.analyze();
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        main.putValue("Bundle-ManifestVersion", "2");
        boolean noExtraHeaders = "true".equalsIgnoreCase(this.getProperty("-noextraheaders"));
        if (!noExtraHeaders) {
            main.putValue("Created-By", System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            main.putValue("Tool", "Bnd-" + this.getBndVersion());
            main.putValue("Bnd-LastModified", "" + System.currentTimeMillis());
        }
        if ((exportHeader = Analyzer.printClauses(this.exports, "uses:|include:|exclude:|mandatory:|-import:", true)).length() > 0) {
            main.putValue("Export-Package", exportHeader);
        } else {
            main.remove("Export-Package");
        }
        Map<String, Map<String, String>> temp = Analyzer.removeKeys(this.imports, "java.");
        if (!temp.isEmpty()) {
            main.putValue("Import-Package", Analyzer.printClauses(temp, "resolution:"));
        } else {
            main.remove("Import-Package");
        }
        temp = this.newMap(this.contained);
        temp.keySet().removeAll(this.exports.keySet());
        if (!temp.isEmpty()) {
            main.putValue("Private-Package", Analyzer.printClauses(temp, ""));
        } else {
            main.remove("Private-Package");
        }
        if (!this.ignored.isEmpty()) {
            main.putValue("Ignore-Package", Analyzer.printClauses(this.ignored, ""));
        } else {
            main.remove("Ignore-Package");
        }
        if (this.bundleClasspath != null && !this.bundleClasspath.isEmpty()) {
            main.putValue("Bundle-ClassPath", Analyzer.printClauses(this.bundleClasspath, ""));
        } else {
            main.remove("Bundle-ClassPath");
        }
        Enumeration<?> h = this.getProperties().propertyNames();
        while (h.hasMoreElements()) {
            String value;
            String header = (String)h.nextElement();
            if (header.trim().length() == 0) {
                this.warning("Empty property set with value: " + this.getProperties().getProperty(header), new Object[0]);
                continue;
            }
            if (this.isMissingPlugin(header.trim())) {
                this.error("Missing plugin for command %s", header);
            }
            if (!Character.isUpperCase(header.charAt(0))) {
                if (header.charAt(0) != '@') continue;
                this.doNameSection(manifest, header);
                continue;
            }
            if (header.equals("Bundle-ClassPath") || header.equals("Export-Package") || header.equals("Import-Package")) continue;
            if (header.equalsIgnoreCase("Name")) {
                this.error("Your bnd file contains a header called 'Name'. This interferes with the manifest name section.", new Object[0]);
                continue;
            }
            if (!Verifier.HEADER_PATTERN.matcher(header).matches() || (value = this.getProperty(header)) == null || main.getValue(header) != null) continue;
            if (value.trim().length() == 0) {
                main.remove(header);
                continue;
            }
            if (value.trim().equals("<<EMPTY>>")) {
                main.putValue(header, "");
                continue;
            }
            main.putValue(header, value);
        }
        String bsn = this.getBsn();
        if (main.getValue("Bundle-SymbolicName") == null) {
            main.putValue("Bundle-SymbolicName", bsn);
        }
        if (main.getValue("Bundle-Name") == null) {
            main.putValue("Bundle-Name", bsn);
        }
        if (main.getValue("Bundle-Version") == null) {
            main.putValue("Bundle-Version", "0");
        }
        this.merge(manifest, this.dot.getManifest());
        Map<String, Map<String, String>> removes = this.parseHeader(this.getProperty("-removeheaders"));
        Set<Instruction> matchers = Instruction.replaceWithInstruction(removes).keySet();
        Collection<Object> toBeRemoved = Instruction.select(matchers, main.keySet());
        Iterator<Object> i = main.keySet().iterator();
        while (i.hasNext()) {
            if (!toBeRemoved.contains(i.next())) continue;
            i.remove();
        }
        this.dot.setManifest(manifest);
        return manifest;
    }

    private void doNameSection(Manifest manifest, String header) {
        String path = header.replace('@', '/');
        int n = path.lastIndexOf(47);
        String name = path.substring(n + 1);
        path = path.substring(1, n);
        if (name.length() != 0 && path.length() != 0) {
            Attributes attrs = manifest.getAttributes(path);
            if (attrs == null) {
                attrs = new Attributes();
                manifest.getEntries().put(path, attrs);
            }
            attrs.putValue(name, this.getProperty(header));
        } else {
            this.warning("Invalid header (starts with @ but does not seem to be for the Name section): %s", header);
        }
    }

    public String getBsn() {
        String value = this.getProperty("Bundle-SymbolicName");
        if (value == null) {
            if (this.getPropertiesFile() != null) {
                value = this.getPropertiesFile().getName();
            }
            String projectName = this.getBase().getName();
            if (value == null || value.equals("bnd.bnd")) {
                value = projectName;
            } else if (value.endsWith(".bnd") && !(value = value.substring(0, value.length() - 4)).startsWith(this.getBase().getName())) {
                value = projectName + "." + value;
            }
        }
        if (value == null) {
            return "untitled";
        }
        int n = value.indexOf(59);
        if (n > 0) {
            value = value.substring(0, n);
        }
        return value.trim();
    }

    public String _bsn(String[] args) {
        return this.getBsn();
    }

    public String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map<String, Map<String, Resource>> map = bundle.getDirectories();
        for (String directory : map.keySet()) {
            if (directory.equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }

    public Map<String, Map<String, String>> getBundleClasspath() {
        return this.bundleClasspath;
    }

    public Map<String, Map<String, String>> getContained() {
        return this.contained;
    }

    public Map<String, Map<String, String>> getExports() {
        return this.exports;
    }

    public Map<String, Map<String, String>> getImports() {
        return this.imports;
    }

    public Jar getJar() {
        return this.dot;
    }

    public Map<String, Map<String, String>> getReferred() {
        return this.referred;
    }

    public Set<String> getUnreachable() {
        HashSet<String> unreachable = new HashSet<String>(this.uses.keySet());
        for (String packageName : this.exports.keySet()) {
            this.removeTransitive(packageName, unreachable);
        }
        if (this.activator != null) {
            String pack = this.activator.substring(0, this.activator.lastIndexOf(46));
            this.removeTransitive(pack, unreachable);
        }
        return unreachable;
    }

    public Map<String, Set<String>> getUses() {
        return this.uses;
    }

    public String getBndVersion() {
        return this.getBndInfo("version", "1.42.1");
    }

    public long getBndLastModified() {
        String time = this.getBndInfo("modified", "0");
        try {
            return Long.parseLong(time);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getBndInfo(String key, String defaultValue) {
        if (bndInfo == null) {
            bndInfo = new Properties();
            try {
                InputStream in = Analyzer.class.getResourceAsStream("bnd.info");
                if (in != null) {
                    bndInfo.load(in);
                    in.close();
                }
            }
            catch (IOException ioe) {
                this.warning("Could not read bnd.info in " + Analyzer.class.getPackage() + ioe, new Object[0]);
            }
        }
        return bndInfo.getProperty(key, defaultValue);
    }

    public void mergeManifest(Manifest manifest) throws IOException {
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                String key = name.toString();
                if (key.startsWith("-") || this.getProperty(key) != null) continue;
                this.setProperty(key, (String)attributes.get(name));
            }
        }
    }

    @Override
    public void setBase(File file) {
        super.setBase(file);
        this.getProperties().put("project.dir", this.getBase().getAbsolutePath());
    }

    public void setClasspath(File[] classpath) throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        for (int i = 0; i < classpath.length; ++i) {
            if (classpath[i].exists()) {
                Jar current = new Jar(classpath[i]);
                list.add(current);
                continue;
            }
            this.error("Missing file on classpath: %s", classpath[i]);
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.addClasspath((Jar)i.next());
        }
    }

    public void setClasspath(Jar[] classpath) {
        for (int i = 0; i < classpath.length; ++i) {
            this.addClasspath(classpath[i]);
        }
    }

    public void setClasspath(String[] classpath) {
        for (int i = 0; i < classpath.length; ++i) {
            Jar jar = this.getJarFromName(classpath[i], " setting classpath");
            if (jar == null) continue;
            this.addClasspath(jar);
        }
    }

    public Jar setJar(File jar) throws IOException {
        Jar jarx = new Jar(jar);
        this.addClose(jarx);
        return this.setJar(jarx);
    }

    public Jar setJar(Jar jar) {
        this.dot = jar;
        return jar;
    }

    @Override
    protected void begin() {
        if (!this.inited) {
            this.inited = true;
            super.begin();
            this.updateModified(this.getBndLastModified(), "bnd last modified");
            this.verifyManifestHeadersCase(this.getProperties());
        }
    }

    public boolean checkClass(String interfaceName) {
        int n;
        String pack;
        String path = Clazz.fqnToPath(interfaceName);
        if (this.classspace.containsKey(path)) {
            return true;
        }
        if (interfaceName.startsWith("java.")) {
            return true;
        }
        if (this.imports != null && !this.imports.isEmpty() && this.imports.containsKey(pack = (n = (pack = interfaceName).lastIndexOf(46)) > 0 ? pack.substring(0, n) : ".")) {
            return true;
        }
        int n2 = interfaceName.lastIndexOf(46);
        if (n2 > 0 && n2 + 1 < interfaceName.length() && Character.isUpperCase(interfaceName.charAt(n2 + 1))) {
            return this.checkClass(interfaceName.substring(0, n2) + '$' + interfaceName.substring(n2 + 1));
        }
        return false;
    }

    Jar getJarFromName(String name, String from) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.getBase(), name);
        }
        if (file.exists()) {
            try {
                Jar jar = new Jar(file);
                this.addClose(jar);
                return jar;
            }
            catch (Exception e) {
                this.error("Exception in parsing jar file for " + from + ": " + name + " " + e, new Object[0]);
            }
        }
        try {
            URL url = new URL(name);
            Jar jar = new Jar(this.fileName(url.getPath()));
            this.addClose(jar);
            URLConnection connection = url.openConnection();
            InputStream in = connection.getInputStream();
            long lastModified = connection.getLastModified();
            if (lastModified == 0L) {
                lastModified = System.currentTimeMillis();
            }
            EmbeddedResource.build(jar, in, lastModified);
            in.close();
            return jar;
        }
        catch (IOException ee) {
            for (Jar entry : this.getClasspath()) {
                if (entry.source == null || !entry.source.getName().equals(name)) continue;
                return entry;
            }
            return null;
        }
    }

    private String fileName(String path) {
        int n = path.lastIndexOf(47);
        if (n > 0) {
            return path.substring(n + 1);
        }
        return path;
    }

    void merge(Manifest result, Manifest old) throws IOException {
        if (old != null) {
            for (Map.Entry<Object, Object> entry : old.getMainAttributes().entrySet()) {
                Attributes.Name name = (Attributes.Name)entry.getKey();
                String value = (String)entry.getValue();
                if (name.toString().equalsIgnoreCase("Created-By")) {
                    name = new Attributes.Name("Originally-Created-By");
                }
                if (result.getMainAttributes().containsKey(name)) continue;
                result.getMainAttributes().put(name, value);
            }
            Map<String, Attributes> oldEntries = old.getEntries();
            Map<String, Attributes> newEntries = result.getEntries();
            for (Map.Entry<String, Attributes> entry : oldEntries.entrySet()) {
                if (newEntries.containsKey(entry.getKey())) continue;
                newEntries.put(entry.getKey(), entry.getValue());
            }
        }
    }

    String stem(String name) {
        int n = name.lastIndexOf(46);
        if (n > 0) {
            return name.substring(0, n);
        }
        return name;
    }

    void verifyManifestHeadersCase(Properties properties) {
        block0: for (String string : properties.keySet()) {
            for (int j = 0; j < headers.length; ++j) {
                if (headers[j].equals(string) || !headers[j].equalsIgnoreCase(string)) continue;
                this.warning("Using a standard OSGi header with the wrong case (bnd is case sensitive!), using: " + string + " and expecting: " + headers[j], new Object[0]);
                continue block0;
            }
        }
    }

    Map<String, Map<String, String>> doExportsToImports(Map<String, Map<String, String>> exports) {
        HashSet<String> privatePackages = new HashSet<String>(this.contained.keySet());
        privatePackages.removeAll(exports.keySet());
        Set privateReferences = this.newSet();
        for (String p : privatePackages) {
            Set<String> uses = this.uses.get(p);
            if (uses == null) continue;
            privateReferences.addAll(uses);
        }
        HashSet<String> toBeImported = new HashSet<String>(exports.keySet());
        toBeImported.retainAll(privateReferences);
        if (this.imports != null) {
            toBeImported.removeAll(this.imports.keySet());
        }
        Iterator i = toBeImported.iterator();
        block1: while (i.hasNext()) {
            Set<String> usedByExportedPackage = this.uses.get(i.next());
            for (String privatePackage : privatePackages) {
                if (!usedByExportedPackage.contains(privatePackage)) continue;
                i.remove();
                continue block1;
            }
        }
        Map<String, Map<String, String>> result = Analyzer.newMap();
        for (String ep : toBeImported) {
            Map<String, String> parameters = exports.get(ep);
            String noimport = parameters.get("-noimport:");
            if (noimport != null && noimport.equalsIgnoreCase("true")) continue;
            parameters = this.newMap(parameters);
            parameters.remove("version");
            result.put(ep, parameters);
        }
        return result;
    }

    private <T> boolean intersects(Collection<T> aa, Collection<T> bb) {
        if (((Object)aa).equals(bb)) {
            return true;
        }
        if (aa.size() > bb.size()) {
            return this.intersects(bb, aa);
        }
        for (T t : aa) {
            if (!bb.contains(t)) continue;
            return true;
        }
        return false;
    }

    public boolean referred(String packageName) {
        for (Map.Entry<String, Set<String>> contained : this.uses.entrySet()) {
            if (contained.getKey().equals(packageName) || !contained.getValue().contains(packageName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyzeClasspath() throws Exception {
        this.classpathExports = Analyzer.newHashMap();
        for (Jar current : this.getClasspath()) {
            this.checkManifest(current);
            for (String dir : current.getDirectories().keySet()) {
                Resource resource = current.getResource(dir + "/packageinfo");
                if (resource == null) continue;
                InputStream in = resource.openInputStream();
                try {
                    String version = Analyzer.parsePackageInfo(in);
                    this.setPackageInfo(dir, "version", version);
                }
                finally {
                    in.close();
                }
            }
        }
    }

    void checkManifest(Jar jar) {
        try {
            Map<String, Map<String, String>> exported;
            String exportHeader;
            Manifest m = jar.getManifest();
            if (m != null && (exportHeader = m.getMainAttributes().getValue("Export-Package")) != null && (exported = this.parseHeader(exportHeader)) != null) {
                for (Map.Entry<String, Map<String, String>> entry : exported.entrySet()) {
                    if (this.classpathExports.containsKey(entry.getKey())) continue;
                    this.classpathExports.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            this.warning("Erroneous Manifest for " + jar + " " + e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void augmentImports() {
        for (String packageName : this.imports.keySet()) {
            this.setProperty("@package", packageName);
            try {
                Map<String, String> importAttributes = this.imports.get(packageName);
                Map<String, String> exporterAttributes = this.classpathExports.get(packageName);
                if (exporterAttributes == null) {
                    exporterAttributes = this.exports.get(packageName);
                }
                if (exporterAttributes != null) {
                    this.augmentVersion(importAttributes, exporterAttributes);
                    this.augmentMandatory(importAttributes, exporterAttributes);
                    if (exporterAttributes.containsKey("-import:")) {
                        importAttributes.put("-import:", exporterAttributes.get("-import:"));
                    }
                }
                this.fixupAttributes(importAttributes);
                this.removeAttributes(importAttributes);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void augmentExports() {
        for (String packageName : this.exports.keySet()) {
            this.setProperty("@package", packageName);
            try {
                Map<String, String> attributes = this.exports.get(packageName);
                Map<String, String> exporterAttributes = this.classpathExports.get(packageName);
                if (exporterAttributes == null) continue;
                for (Map.Entry<String, String> entry : exporterAttributes.entrySet()) {
                    String key = entry.getKey();
                    if (key.equalsIgnoreCase("specification-version")) {
                        key = "version";
                    }
                    if (key.endsWith(":") || attributes.containsKey(key)) continue;
                    attributes.put(key, entry.getValue());
                }
                this.fixupAttributes(attributes);
                this.removeAttributes(attributes);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    void fixupAttributes(Map<String, String> attributes) {
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            if (value.indexOf(36) < 0) continue;
            value = this.getReplacer().process(value);
            attributes.put(key, value);
        }
    }

    void removeAttributes(Map<String, String> attributes) {
        String remove = attributes.remove("-remove-attribute:");
        Instruction removeInstr = null;
        if (remove != null) {
            removeInstr = Instruction.getPattern(remove);
        }
        Iterator<Map.Entry<String, String>> i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue().equals("!")) {
                i.remove();
                continue;
            }
            if (removeInstr == null || !removeInstr.matches(entry.getKey())) continue;
            i.remove();
        }
    }

    private void augmentMandatory(Map<String, String> currentAttributes, Map<String, String> exporter) {
        String mandatory = exporter.get("mandatory:");
        if (mandatory != null) {
            String[] attrs = mandatory.split("\\s*,\\s*");
            for (int i = 0; i < attrs.length; ++i) {
                if (currentAttributes.containsKey(attrs[i])) continue;
                currentAttributes.put(attrs[i], exporter.get(attrs[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void augmentVersion(Map<String, String> currentAttributes, Map<String, String> exporter) {
        String exportVersion = exporter.get("version");
        if (exportVersion == null) {
            return;
        }
        exportVersion = Analyzer.cleanupVersion(exportVersion);
        String importRange = currentAttributes.get("version");
        boolean impl = Analyzer.isTrue(currentAttributes.get("provide:"));
        try {
            this.setProperty("@", exportVersion);
            if (importRange != null) {
                importRange = Analyzer.cleanupVersion(importRange);
                importRange = this.getReplacer().process(importRange);
            } else {
                importRange = this.getVersionPolicy(impl);
            }
        }
        finally {
            this.unsetProperty("@");
        }
        currentAttributes.put("version", importRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String calculateVersionRange(String version, boolean impl) {
        this.setProperty("@", version);
        try {
            String string = this.getVersionPolicy(impl);
            return string;
        }
        finally {
            this.unsetProperty("@");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUses(Map<String, Map<String, String>> exports, Map<String, Set<String>> uses, Map<String, Map<String, String>> imports) {
        if ("true".equalsIgnoreCase(this.getProperty("-nouses"))) {
            return;
        }
        for (String packageName : exports.keySet()) {
            this.setProperty("@package", packageName);
            try {
                Set<String> usedPackages;
                Map<String, String> clause = exports.get(packageName);
                String override = clause.get("uses:");
                if (override == null) {
                    override = "<<USES>>";
                }
                if ((usedPackages = uses.get(packageName)) == null) continue;
                HashSet<String> sharedPackages = new HashSet<String>();
                sharedPackages.addAll(imports.keySet());
                sharedPackages.addAll(exports.keySet());
                usedPackages.retainAll(sharedPackages);
                usedPackages.remove(packageName);
                StringBuffer sb = new StringBuffer();
                String del = "";
                for (String usedPackage : usedPackages) {
                    if (usedPackage.startsWith("java.")) continue;
                    sb.append(del);
                    sb.append(usedPackage);
                    del = ",";
                }
                if (override.indexOf(36) >= 0) {
                    this.setProperty("@uses", sb.toString());
                    override = this.getReplacer().process(override);
                    this.unsetProperty("@uses");
                } else {
                    override = override.replaceAll("<<USES>>", sb.toString()).trim();
                }
                if (override.endsWith(",")) {
                    override = override.substring(0, override.length() - 1);
                }
                if (override.startsWith(",")) {
                    override = override.substring(1);
                }
                if (override.length() <= 0) continue;
                clause.put("uses:", override);
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    void removeTransitive(String name, Set<String> unreachable) {
        if (!unreachable.contains(name)) {
            return;
        }
        unreachable.remove(name);
        Set<String> ref = this.uses.get(name);
        if (ref != null) {
            for (String element : ref) {
                this.removeTransitive(element, unreachable);
            }
        }
    }

    void setPackageInfo(String dir, String key, String value) {
        if (value != null) {
            String pack = dir.replace('/', '.');
            Map<String, String> map = this.classpathExports.get(pack);
            if (map == null) {
                map = new HashMap<String, String>();
                this.classpathExports.put(pack, map);
            }
            if (!map.containsKey("version")) {
                map.put(key, value);
            } else if (!map.get("version").equals(value)) {
                // empty if block
            }
        }
    }

    @Override
    public void close() {
        if (this.diagnostics) {
            PrintStream out = System.out;
            out.printf("Current directory            : %s\n", new File("").getAbsolutePath());
            out.println("Classpath used");
            for (Jar jar : this.getClasspath()) {
                out.printf("File                                : %s\n", jar.getSource());
                out.printf("File abs path                       : %s\n", jar.getSource().getAbsolutePath());
                out.printf("Name                                : %s\n", jar.getName());
                Map<String, Map<String, Resource>> dirs = jar.getDirectories();
                for (Map.Entry<String, Map<String, Resource>> entry : dirs.entrySet()) {
                    Map<String, Resource> dir = entry.getValue();
                    String name = entry.getKey().replace('/', '.');
                    if (dir != null) {
                        out.printf("                                      %-30s %d\n", name, dir.size());
                        continue;
                    }
                    out.printf("                                      %-30s <<empty>>\n", name);
                }
            }
        }
        super.close();
        if (this.dot != null) {
            this.dot.close();
        }
        if (this.classpath != null) {
            for (Jar jar : this.classpath) {
                jar.close();
            }
        }
    }

    public String _findpath(String[] args) {
        return this.findPath("findpath", args, true);
    }

    public String _findname(String[] args) {
        return this.findPath("findname", args, false);
    }

    String findPath(String name, String[] args, boolean fullPathName) {
        if (args.length > 3) {
            this.warning("Invalid nr of arguments to " + name + " " + Arrays.asList(args) + ", syntax: ${" + name + " (; reg-expr (; replacement)? )? }", new Object[0]);
            return null;
        }
        String regexp = ".*";
        String replace = null;
        switch (args.length) {
            case 3: {
                replace = args[2];
            }
            case 2: {
                regexp = args[1];
            }
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        Pattern expr = Pattern.compile(regexp);
        for (String path : this.dot.getResources().keySet()) {
            Matcher m;
            int n;
            if (!fullPathName && (n = path.lastIndexOf(47)) >= 0) {
                path = path.substring(n + 1);
            }
            if (!(m = expr.matcher(path)).matches()) continue;
            if (replace != null) {
                path = m.replaceAll(replace);
            }
            sb.append(del);
            sb.append(path);
            del = ", ";
        }
        return sb.toString();
    }

    public void putAll(Map<String, String> additional, boolean force) {
        for (Map.Entry<String, String> entry : additional.entrySet()) {
            if (!force && this.getProperties().get(entry.getKey()) != null) continue;
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public List<Jar> getClasspath() {
        if (this.firstUse) {
            this.firstUse = false;
            String cp = this.getProperty("-classpath");
            if (cp != null) {
                for (String s : Analyzer.split(cp)) {
                    Jar jar = this.getJarFromName(s, "getting classpath");
                    if (jar != null) {
                        this.addClasspath(jar);
                        continue;
                    }
                    this.warning("Cannot find entry on -classpath: %s", s);
                }
            }
        }
        return this.classpath;
    }

    public void addClasspath(Jar jar) {
        if (this.isPedantic() && jar.getResources().isEmpty()) {
            this.warning("There is an empty jar or directory on the classpath: " + jar.getName(), new Object[0]);
        }
        this.classpath.add(jar);
    }

    public void addClasspath(File cp) throws IOException {
        if (!cp.exists()) {
            this.warning("File on classpath that does not exist: " + cp, new Object[0]);
        }
        Jar jar = new Jar(cp);
        this.addClose(jar);
        this.classpath.add(jar);
    }

    @Override
    public void clear() {
        this.classpath.clear();
    }

    public Jar getTarget() {
        return this.dot;
    }

    protected Map<String, Clazz> analyzeBundleClasspath(Jar dot, Map<String, Map<String, String>> bundleClasspath, Map<String, Map<String, String>> contained, Map<String, Map<String, String>> referred, Map<String, Set<String>> uses) throws Exception {
        HashMap<String, Clazz> classSpace = new HashMap<String, Clazz>();
        Set hide = Create.set();
        if (bundleClasspath.isEmpty()) {
            this.analyzeJar(dot, "", classSpace, contained, referred, uses, hide);
        } else {
            for (String path : bundleClasspath.keySet()) {
                Map<String, String> info = bundleClasspath.get(path);
                if (path.equals(".")) {
                    this.analyzeJar(dot, "", classSpace, contained, referred, uses, hide);
                    continue;
                }
                Resource resource = dot.getResource(path);
                if (resource != null) {
                    try {
                        Jar jar = new Jar(path);
                        this.addClose(jar);
                        EmbeddedResource.build(jar, resource);
                        this.analyzeJar(jar, "", classSpace, contained, referred, uses, hide);
                    }
                    catch (Exception e) {
                        this.warning("Invalid bundle classpath entry: " + path + " " + e, new Object[0]);
                    }
                    continue;
                }
                if (dot.getDirectories().containsKey(path)) {
                    this.analyzeJar(dot, Processor.appendPath(path) + "/", classSpace, contained, referred, uses, hide);
                    continue;
                }
                if ("optional".equals(info.get("resolution:"))) continue;
                this.warning("No sub JAR or directory " + path, new Object[0]);
            }
            for (Clazz c : classSpace.values()) {
                this.formats.add(c.getFormat());
            }
        }
        return classSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeJar(Jar jar, String prefix, Map<String, Clazz> classSpace, Map<String, Map<String, String>> contained, Map<String, Map<String, String>> referred, Map<String, Set<String>> uses, Set<String> hide) throws Exception {
        for (String path : jar.getResources().keySet()) {
            Clazz clazz;
            InputStream in;
            if (!path.startsWith(prefix) || hide.contains(path)) continue;
            hide.add(path);
            String relativePath = path.substring(prefix.length());
            if (classSpace.containsKey(relativePath)) continue;
            String pack = this.getPackage(relativePath);
            if (pack != null && !contained.containsKey(pack) && !this.isMetaData(relativePath)) {
                Map<String, String> info = Analyzer.newMap();
                contained.put(pack, info);
                Resource pinfo = jar.getResource(prefix + pack.replace('.', '/') + "/packageinfo");
                if (pinfo != null) {
                    String version;
                    in = pinfo.openInputStream();
                    try {
                        version = Analyzer.parsePackageInfo(in);
                    }
                    finally {
                        in.close();
                    }
                    if (version != null) {
                        info.put("version", version);
                    }
                }
            }
            if (!path.endsWith(".class")) continue;
            Resource resource = jar.getResource(path);
            try {
                in = resource.openInputStream();
                clazz = new Clazz(relativePath, resource);
                try {
                    if (relativePath.endsWith("/package-info.class")) {
                        Map<String, String> info = contained.get(pack);
                        this.parsePackageInfoClass(clazz, info);
                    } else {
                        clazz.parseClassFile();
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Throwable e) {
                this.error("Invalid class file: " + relativePath, e, new Object[0]);
                e.printStackTrace();
                continue;
            }
            String calculatedPath = clazz.getClassName() + ".class";
            if (!calculatedPath.equals(relativePath) && !this.isNoBundle()) {
                this.error("Class in different directory than declared. Path from class name is " + calculatedPath + " but the path in the jar is " + relativePath + " from " + jar, new Object[0]);
            }
            classSpace.put(relativePath, clazz);
            for (String p : clazz.getReferred()) {
                Map<String, String> attrs = referred.get(p);
                if (attrs != null) continue;
                attrs = Analyzer.newMap();
                referred.put(p, attrs);
            }
            Set<String> t = uses.get(pack);
            if (t == null) {
                t = new LinkedHashSet<String>();
                uses.put(pack, t);
            }
            t.addAll(clazz.getReferred());
            t.remove(pack);
        }
    }

    private void parsePackageInfoClass(final Clazz clazz, final Map<String, String> info) throws Exception {
        clazz.parseClassFileWithCollector(new ClassDataCollector(){

            public void annotation(Annotation a) {
                if (a.name.equals(Clazz.toDescriptor(aQute.bnd.annotation.Version.class))) {
                    String version = (String)a.get("value");
                    if (!info.containsKey("version")) {
                        if (version != null) {
                            version = Analyzer.this.getReplacer().process(version);
                            if (Verifier.VERSION.matcher(version).matches()) {
                                info.put("version", version);
                            } else {
                                Analyzer.this.error("Export annotatio in %s has invalid version info: %s", clazz, version);
                            }
                        }
                    } else {
                        String presentVersion = (String)info.get("version");
                        try {
                            Version av = new Version(presentVersion);
                            Version bv = new Version(version);
                            if (!av.equals((Object)bv)) {
                                Analyzer.this.error("Version from annotation for %s differs with packageinfo or Manifest", Clazz.getPackage(clazz.className));
                            }
                        }
                        catch (Exception e) {}
                    }
                } else if (a.name.equals(Clazz.toDescriptor(Export.class))) {
                    Object[] uses;
                    Object[] excluded;
                    Object[] included;
                    Map<String, String> attrs = Processor.doAttrbutes((Object[])a.get("mandatory"), clazz, Analyzer.this.getReplacer());
                    if (!attrs.isEmpty()) {
                        info.putAll(attrs);
                        info.put("mandatory:", Processor.join(attrs.keySet()));
                    }
                    if (!(attrs = Processor.doAttrbutes((Object[])a.get("optional"), clazz, Analyzer.this.getReplacer())).isEmpty()) {
                        info.putAll(attrs);
                    }
                    if ((included = (Object[])a.get("include")) != null && included.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        String del = "";
                        for (Object i : included) {
                            Matcher m = OBJECT_REFERENCE.matcher((String)i);
                            if (!m.matches()) continue;
                            sb.append(del);
                            sb.append(m.group(2));
                            del = ",";
                        }
                        info.put("include:", sb.toString());
                    }
                    if ((excluded = (Object[])a.get("exclude")) != null && excluded.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        String del = "";
                        for (Object i : excluded) {
                            Matcher m = OBJECT_REFERENCE.matcher((String)i);
                            if (!m.matches()) continue;
                            sb.append(del);
                            sb.append(m.group(2));
                            del = ",";
                        }
                        info.put("exclude:", sb.toString());
                    }
                    if ((uses = (Object[])a.get("uses")) != null && uses.length > 0) {
                        StringBuilder sb;
                        String old = (String)info.get("uses:");
                        if (old == null) {
                            old = "";
                        }
                        String del = (sb = new StringBuilder(old)).length() == 0 ? "" : ",";
                        for (Object use : uses) {
                            sb.append(del);
                            sb.append(use);
                            del = ",";
                        }
                        info.put("uses:", sb.toString());
                    }
                }
            }
        });
    }

    public static String cleanupVersion(String version) {
        Matcher m = Verifier.VERSIONRANGE.matcher(version);
        if (m.matches()) {
            return version;
        }
        m = fuzzyVersionRange.matcher(version);
        if (m.matches()) {
            String prefix = m.group(1);
            String first = m.group(2);
            String last = m.group(3);
            String suffix = m.group(4);
            return prefix + Analyzer.cleanupVersion(first) + "," + Analyzer.cleanupVersion(last) + suffix;
        }
        m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String major = Analyzer.removeLeadingZeroes(m.group(1));
            String minor = Analyzer.removeLeadingZeroes(m.group(3));
            String micro = Analyzer.removeLeadingZeroes(m.group(5));
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            Analyzer.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        Analyzer.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    Analyzer.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    private static String removeLeadingZeroes(String group) {
        int n;
        for (n = 0; group != null && n < group.length() - 1 && group.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return group;
        }
        return group.substring(n);
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    boolean isMetaData(String pack) {
        for (int i = 0; i < METAPACKAGES.length; ++i) {
            if (!pack.startsWith(METAPACKAGES[i])) continue;
            return true;
        }
        return false;
    }

    public String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    static String parsePackageInfo(InputStream jar) throws IOException {
        try {
            Properties p = new Properties();
            p.load(jar);
            jar.close();
            if (p.containsKey("version")) {
                return p.getProperty("version");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getVersionPolicy(boolean implemented) {
        if (implemented) {
            String s = this.getProperty("-provider-policy");
            if (s != null) {
                return s;
            }
            s = this.getProperty("-versionpolicy-impl");
            if (s != null) {
                return s;
            }
            return this.getProperty("-versionpolicy", DEFAULT_PROVIDER_POLICY);
        }
        String s = this.getProperty("-consumer-policy");
        if (s != null) {
            return s;
        }
        s = this.getProperty("-versionpolicy-uses");
        if (s != null) {
            return s;
        }
        return this.getProperty("-versionpolicy", DEFAULT_CONSUMER_POLICY);
    }

    public String _classes(String ... args) throws Exception {
        Collection<Clazz> matched = this.getClasses(args);
        if (matched.isEmpty()) {
            return "";
        }
        return Analyzer.join(matched);
    }

    public Collection<Clazz> getClasses(String ... args) throws Exception {
        HashSet<Clazz> matched = new HashSet<Clazz>(this.classspace.values());
        for (int i = 1; i < args.length; ++i) {
            if (args.length < i + 1) {
                throw new IllegalArgumentException("${classes} macro must have odd number of arguments. " + _classesHelp);
            }
            String typeName = args[i];
            if (typeName.equalsIgnoreCase("extending")) {
                typeName = "extends";
            } else if (typeName.equalsIgnoreCase("importing")) {
                typeName = "imports";
            } else if (typeName.equalsIgnoreCase("implementing")) {
                typeName = "implements";
            }
            Clazz.QUERY type = Clazz.QUERY.valueOf(typeName.toUpperCase());
            if (type == null) {
                throw new IllegalArgumentException("${classes} has invalid type: " + typeName + ". " + _classesHelp);
            }
            Instruction instr = null;
            if (Clazz.HAS_ARGUMENT.contains((Object)type)) {
                char c;
                int ci;
                StringBuilder sb = new StringBuilder();
                String s = args[++i];
                if (type == Clazz.QUERY.ANNOTATION) {
                    sb.append("L");
                    for (ci = 0; ci < s.length(); ++ci) {
                        c = s.charAt(ci);
                        if (c == '.') {
                            sb.append("/");
                            continue;
                        }
                        sb.append(c);
                    }
                    sb.append(';');
                } else {
                    for (ci = 0; ci < s.length(); ++ci) {
                        c = s.charAt(ci);
                        if (c == '.') {
                            sb.append("(/|\\$)");
                            continue;
                        }
                        sb.append(c);
                    }
                }
                instr = Instruction.getPattern(sb.toString());
            }
            Iterator c = matched.iterator();
            while (c.hasNext()) {
                Clazz clazz = (Clazz)c.next();
                if (clazz.is(type, instr, this)) continue;
                c.remove();
            }
        }
        return matched;
    }

    public String _exporters(String[] args) throws Exception {
        Macro.verifyCommand(args, "${exporters;<packagename>}, returns the list of jars that export the given package", null, 2, 2);
        StringBuilder sb = new StringBuilder();
        String del = "";
        String pack = args[1].replace('.', '/');
        for (Jar jar : this.classpath) {
            if (!jar.getDirectories().containsKey(pack)) continue;
            sb.append(del);
            sb.append(jar.getName());
        }
        return sb.toString();
    }

    public Map<String, Clazz> getClassspace() {
        return this.classspace;
    }

    public Resource findResource(String path) {
        for (Jar entry : this.getClasspath()) {
            Resource r = entry.getResource(path);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public Clazz findClass(String path) throws Exception {
        Clazz c = this.classspace.get(path);
        if (c != null) {
            return c;
        }
        c = this.importedClassesCache.get(path);
        if (c != null) {
            return c;
        }
        Resource r = this.findResource(path);
        if (r != null) {
            c = new Clazz(path, r);
            c.parseClassFile();
            this.importedClassesCache.put(path, c);
        }
        return c;
    }

    public String getVersion() {
        String version = this.getProperty("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        return version;
    }

    public boolean isNoBundle() {
        return Analyzer.isTrue(this.getProperty("-resourceonly")) || Analyzer.isTrue(this.getProperty("-nomanifest"));
    }

    public void referTo(String impl) {
        String pack = Clazz.getPackage(impl);
        if (!this.referred.containsKey(pack)) {
            this.referred.put(pack, new LinkedHashMap());
        }
    }

    public MultiMap<Set<String>, String> getGroups() {
        MultiMap map = new MultiMap();
        Set<String> keys = this.uses.keySet();
        for (Map.Entry<String, Set<String>> entry : this.uses.entrySet()) {
            HashSet newSet = new HashSet(entry.getValue());
            newSet.retainAll(keys);
            map.put((Object)entry.getKey(), newSet);
        }
        Set scc = Tarjan.tarjan((Map)map);
        MultiMap grouped = new MultiMap();
        for (Set group : scc) {
            for (String p : group) {
                grouped.addAll((Object)group, (Collection)this.uses.get(p));
            }
        }
        return grouped;
    }

    void doRequireBnd() {
        String require = this.getProperty("-require-bnd");
        if (require != null) {
            try {
                Version v;
                VersionRange range = new VersionRange(require);
                String bndVersion = this.getBndVersion();
                if (bndVersion != null && !range.includes(v = new Version(bndVersion))) {
                    this.error("%s requires version %s but this bnd is actually version %s", this, range, bndVersion);
                }
            }
            catch (Exception e) {
                this.error("Do not understand format of %s, it is %s, gave error: %s", "-require-bnd", require, e);
            }
        }
    }

    static {
        versionPattern = Pattern.compile("(\\d+\\.\\d+)\\.\\d+.*");
        OBJECT_REFERENCE = Pattern.compile("L([^/]+/)*([^;]+);");
        fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
        fuzzyVersionRange = Pattern.compile("(\\(|\\[)\\s*([-\\da-zA-Z.]+)\\s*,\\s*([-\\da-zA-Z.]+)\\s*(\\]|\\))", 32);
        fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);
        nummeric = Pattern.compile("\\d*");
        _classesHelp = "${classes;'implementing'|'extending'|'importing'|'named'|'version'|'any';<pattern>}, Return a list of class fully qualified class names that extend/implement/import any of the contained classes matching the pattern\n";
    }
}

