/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.routebox.RouteboxConfiguration;
import org.apache.camel.component.routebox.RouteboxEndpoint;
import org.apache.camel.component.routebox.direct.RouteboxDirectEndpoint;
import org.apache.camel.component.routebox.seda.RouteboxSedaEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class RouteboxComponent
extends DefaultComponent {
    final RouteboxConfiguration config;
    private final Map<String, BlockingQueue<Exchange>> queues = new HashMap<String, BlockingQueue<Exchange>>();

    public RouteboxComponent() {
        this.config = new RouteboxConfiguration();
    }

    public RouteboxComponent(CamelContext context) {
        super(context);
        this.config = new RouteboxConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RouteboxEndpoint blackboxRouteEndpoint = null;
        this.config.parseURI(new URI(uri), parameters, this);
        if (this.config.getInnerProtocol().equalsIgnoreCase("direct")) {
            blackboxRouteEndpoint = new RouteboxDirectEndpoint(uri, (Component)this, this.config);
            this.setProperties(blackboxRouteEndpoint.getConfig(), parameters);
        } else {
            String baseUri = this.getQueueKey(uri);
            blackboxRouteEndpoint = new RouteboxSedaEndpoint(uri, this, this.config, this.createQueue(baseUri, parameters));
            this.setProperties(blackboxRouteEndpoint.getConfig(), parameters);
        }
        return blackboxRouteEndpoint;
    }

    public synchronized BlockingQueue<Exchange> createQueue(String uri, Map<String, Object> parameters) {
        if (this.queues.containsKey(uri)) {
            return this.queues.get(uri);
        }
        Integer size = this.config.getQueueSize();
        LinkedBlockingQueue<Object> queue = size != null && size > 0 ? new LinkedBlockingQueue(size) : new LinkedBlockingQueue<Exchange>();
        this.queues.put(uri, queue);
        return queue;
    }

    protected String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    protected void doStop() throws Exception {
        this.queues.clear();
        super.doStop();
    }
}

