/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.util.Hashtable;
import java.util.Map;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultCounterListener
implements CounterListener {
    private Map<OID, Counter32> counters = new Hashtable<OID, Counter32>();
    private boolean countRegisteredOnly;

    @Override
    public synchronized void incrementCounter(CounterEvent event) {
        OID id = event.getOid();
        Counter32 counter = this.counters.get(id);
        if (counter == null) {
            if (this.countRegisteredOnly) {
                return;
            }
            counter = new Counter32(1L);
            this.counters.put(id, counter);
        } else {
            counter.increment();
        }
        event.setCurrentValue((Variable)counter.clone());
    }

    public synchronized Counter32 add(OID oid, Counter32 counter) {
        Counter32 oldCounter = this.counters.get(oid);
        if (oldCounter != null) {
            long value = oldCounter.getValue();
            counter.setValue(counter.getValue() + value);
        }
        return this.counters.put(oid, counter);
    }

    public synchronized Counter32 remove(OID oid) {
        return this.counters.remove(oid);
    }

    public boolean isCountRegisteredOnly() {
        return this.countRegisteredOnly;
    }

    public void setCountRegisteredOnly(boolean countRegisteredOnly) {
        this.countRegisteredOnly = countRegisteredOnly;
    }
}

