/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.patch.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.patch.Patch;
import org.fusesource.patch.PatchException;
import org.fusesource.patch.Result;
import org.fusesource.patch.Service;
import org.fusesource.patch.commands.PatchCommandSupport;

@Command(scope="patch", name="install", description="Install a patch")
public class Install
extends PatchCommandSupport {
    @Argument(name="PATCH", description="name of the patch to install", required=true, multiValued=false)
    String patchId;
    @Option(name="--force", description="Force the installation of the patch")
    boolean force;
    @Option(name="--synchronous", description="Synchronous installation (use with caution)")
    boolean synchronous;

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = service.getPatch(this.patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + this.patchId + "' not found");
        }
        if (patch.isInstalled()) {
            throw new PatchException("Patch '" + this.patchId + "' is already installed");
        }
        Result result = patch.install(this.force, this.synchronous);
        this.display(result);
    }
}

