/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactoryImpl<S>
extends AbstractComponentManager<S>
implements ComponentFactory,
ComponentHolder {
    private final Map<SingleComponentManager<S>, SingleComponentManager<S>> m_componentInstances = new IdentityHashMap<SingleComponentManager<S>, SingleComponentManager<S>>();
    private volatile Dictionary<String, Object> m_configuration = new Hashtable<String, Object>();
    private volatile boolean m_hasConfiguration;
    protected volatile long m_changeCount = -1L;
    protected TargetedPID m_targetedPID;

    public ComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata, new ComponentMethods());
    }

    @Override
    public boolean isFactory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInstance newInstance(Dictionary<String, ?> dictionary) {
        SingleComponentManager<S> cm = this.createComponentManager();
        this.log(4, "Creating new instance from component factory {0} with configuration {1}", new Object[]{this.getComponentMetadata().getName(), dictionary}, null);
        cm.setFactoryProperties(dictionary);
        cm.reconfigure(this.m_configuration, this.m_changeCount, this.m_targetedPID);
        cm.enableInternal();
        cm.activateInternal(this.getTrackingCount().get());
        ComponentInstance instance = cm.getComponentInstance();
        if (instance == null || instance.getInstance() == null) {
            cm.dispose(5);
            throw new ComponentException("Failed activating component");
        }
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.put(cm, cm);
        }
        return instance;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentFactoryImpl)) {
            return false;
        }
        ComponentFactoryImpl other = (ComponentFactoryImpl)object;
        return this.getComponentMetadata().getName().equals(other.getComponentMetadata().getName());
    }

    public int hashCode() {
        return this.getComponentMetadata().getName().hashCode();
    }

    @Override
    protected boolean createComponent() {
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
    }

    @Override
    protected String[] getProvidedServices() {
        return new String[]{ComponentFactory.class.getName()};
    }

    @Override
    public boolean hasConfiguration() {
        return this.m_hasConfiguration;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        Dictionary<String, Object> props = this.getServiceProperties();
        List<ReferenceMetadata> depMetaData = this.getComponentMetadata().getDependencies();
        for (ReferenceMetadata rm : depMetaData) {
            if (rm.getTarget() == null) continue;
            props.put(rm.getTargetPropertyName(), rm.getTarget());
        }
        for (String key : Collections.list(this.m_configuration.keys())) {
            if (!key.endsWith(".target")) continue;
            props.put(key, this.m_configuration.get(key));
        }
        return props;
    }

    @Override
    public void setServiceProperties(Dictionary serviceProperties) {
        throw new IllegalStateException("ComponentFactory service properties are immutable");
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        return props;
    }

    @Override
    boolean hasInstance() {
        return false;
    }

    @Override
    protected boolean collectDependencies() {
        return true;
    }

    @Override
    <T> void invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<T> ref, int trackingCount) {
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> reference, int trackingCount) {
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<T> oldRef, int trackingCount) {
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return null;
    }

    @Override
    public void configurationDeleted(String pid) {
        this.m_targetedPID = null;
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.log(4, "Handling configuration removal", null);
            this.m_changeCount = -1L;
            if (!this.m_hasConfiguration) {
                this.log(4, "ignoring configuration removal: not currently configured", null);
                return;
            }
            this.m_hasConfiguration = false;
            this.m_configuration = new Hashtable<String, Object>();
            this.log(4, "Current component factory state={0}", new Object[]{this.getState()}, null);
            if ((this.getState() & 0x100) == 0 && this.getComponentMetadata().isConfigurationRequired()) {
                this.log(4, "Deactivating component factory (required configuration has gone)", null);
                this.deactivateInternal(4, true, false);
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    @Override
    public boolean configurationUpdated(String pid, Dictionary<String, Object> configuration, long changeCount, TargetedPID targetedPid) {
        if (this.m_targetedPID != null && !this.m_targetedPID.equals(targetedPid)) {
            this.log(1, "ImmediateComponentHolder unexpected change in targetedPID from {0} to {1}", new Object[]{this.m_targetedPID, targetedPid}, null);
            throw new IllegalStateException("Unexpected targetedPID change");
        }
        this.m_targetedPID = targetedPid;
        if (configuration != null) {
            if (changeCount <= this.m_changeCount) {
                this.log(4, "ImmediateComponentHolder out of order configuration updated for pid {0} with existing count {1}, new count {2}", new Object[]{this.getConfigurationPid(), this.m_changeCount, changeCount}, null);
                return false;
            }
            this.m_changeCount = changeCount;
        } else {
            this.m_changeCount = -1L;
        }
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.log(4, "Configuration PID updated for Component Factory", null);
            if (this.getComponentMetadata().isConfigurationIgnored()) {
                return false;
            }
            this.m_configuration = configuration;
            this.m_hasConfiguration = true;
            this.log(4, "Current ComponentFactory state={0}", new Object[]{this.getState()}, null);
            if (this.getState() == 64) {
                this.log(4, "Verifying if Active Component Factory is still satisfied", null);
                this.updateTargets(this.getProperties());
                if (!this.verifyDependencyManagers()) {
                    this.log(4, "Component Factory target filters not satisfied anymore: deactivating", null);
                    this.deactivateInternal(2, false, false);
                    return false;
                }
            }
            if (this.getState() == 4 && this.getComponentMetadata().isConfigurationRequired()) {
                this.log(4, "Attempting to activate unsatisfied component", null);
                this.updateTargets(this.getProperties());
                this.activateInternal(this.getTrackingCount().get());
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
        return false;
    }

    @Override
    public synchronized long getChangeCount(String pid) {
        return this.m_changeCount;
    }

    @Override
    public Component[] getComponents() {
        List<AbstractComponentManager<S>> cms = this.getComponentList();
        return cms.toArray(new Component[cms.size()]);
    }

    protected List<AbstractComponentManager<S>> getComponentList() {
        ArrayList<AbstractComponentManager<S>> cms = new ArrayList<AbstractComponentManager<S>>();
        cms.add(this);
        this.getComponentManagers(this.m_componentInstances, cms);
        return cms;
    }

    @Override
    public void enableComponents(boolean async) {
        this.enable(async);
    }

    @Override
    public void disableComponents(boolean async) {
        this.disable(async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeComponents(int reason) {
        ArrayList<AbstractComponentManager<S>> cms = new ArrayList<AbstractComponentManager<S>>();
        this.getComponentManagers(this.m_componentInstances, cms);
        for (AbstractComponentManager abstractComponentManager : cms) {
            abstractComponentManager.dispose(reason);
        }
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.clear();
        }
        this.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposed(SingleComponentManager component) {
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.remove(component);
        }
    }

    private SingleComponentManager<S> createComponentManager() {
        return new ComponentFactoryNewInstance(this.getActivator(), this, this.getComponentMetadata(), this.getComponentMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getComponentManagers(Map<?, SingleComponentManager<S>> componentMap, List<AbstractComponentManager<S>> componentManagers) {
        if (componentMap != null) {
            Map<?, SingleComponentManager<S>> map = componentMap;
            synchronized (map) {
                componentManagers.addAll(componentMap.values());
            }
        }
    }

    @Override
    public TargetedPID getConfigurationTargetedPID(TargetedPID pid) {
        return this.m_targetedPID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentFactoryNewInstance<S>
    extends SingleComponentManager<S> {
        public ComponentFactoryNewInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
            super(activator, componentHolder, metadata, componentMethods, true);
        }
    }
}

