/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.ops4j.pax.swissbox.tracker.DefaultServiceCollectionListener;
import org.ops4j.pax.swissbox.tracker.ServiceCollectionListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCollection<T>
extends AbstractLifecycle
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCollection.class);
    private final BundleContext m_context;
    private final Class<T> m_serviceClass;
    private final ServiceCollectionListener<T> m_collectionListener;
    private Tracker m_serviceTracker;

    public ServiceCollection(BundleContext context, Class<T> serviceClass) {
        this(context, serviceClass, null);
    }

    public ServiceCollection(BundleContext context, Class<T> serviceClass, ServiceCollectionListener<T> collectionListener) {
        LOG.debug("Creating service collection for [" + serviceClass + "]");
        NullArgumentException.validateNotNull(context, "Context");
        NullArgumentException.validateNotNull(serviceClass, "Service class");
        this.m_context = context;
        this.m_serviceClass = serviceClass;
        this.m_collectionListener = collectionListener == null ? new DefaultServiceCollectionListener() : collectionListener;
    }

    @Override
    public Iterator<T> iterator() {
        Object[] trackedServices;
        ArrayList<Object> services = new ArrayList<Object>();
        if (this.m_serviceTracker != null && (trackedServices = this.m_serviceTracker.getServices()) != null) {
            for (Object trackedService : trackedServices) {
                services.add(trackedService);
            }
        }
        return Collections.unmodifiableCollection(services).iterator();
    }

    @Override
    protected void onStart() {
        this.m_serviceTracker = new Tracker(this.m_context, this.m_serviceClass);
        this.m_serviceTracker.open();
    }

    @Override
    protected void onStop() {
        if (this.m_serviceTracker != null) {
            this.m_serviceTracker.close();
            this.m_serviceTracker = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tracker
    extends ServiceTracker {
        public Tracker(BundleContext context, Class<T> serviceClass) {
            super(context, serviceClass.getName(), null);
        }

        public Object addingService(ServiceReference serviceReference) {
            Object service;
            block3: {
                LOG.debug("Added service with reference [" + serviceReference + "]");
                service = null;
                try {
                    service = super.addingService(serviceReference);
                    LOG.debug("Related service [" + service + "]");
                    if (service != null && !ServiceCollection.this.m_collectionListener.serviceAdded(serviceReference, service)) {
                        super.removedService(serviceReference, service);
                        LOG.trace("Service [" + service + "] dropped as requested by listener [" + ServiceCollection.this.m_collectionListener + "]");
                        service = null;
                    }
                }
                catch (RuntimeException e) {
                    if (service == null) break block3;
                    super.removedService(serviceReference, service);
                    LOG.debug("Service [" + service + "] dropped due to exception [" + e.getClass() + ":" + e.getMessage() + "]");
                    throw e;
                }
            }
            return service;
        }

        public void removedService(ServiceReference serviceReference, Object service) {
            LOG.debug("Removed service [" + service + "]");
            try {
                ServiceCollection.this.m_collectionListener.serviceRemoved(serviceReference, service);
            }
            catch (Throwable ignore) {
                LOG.warn("Ignored exception from collection listener", ignore);
            }
            super.removedService(serviceReference, service);
        }
    }
}

