/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.ops4j.spi.NoServiceProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeServiceLoader {
    private ClassLoader classLoader;

    public SafeServiceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> List<T> load(String serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        String resourceName = "/META-INF/services/" + serviceType;
        try {
            Enumeration<URL> resources = this.classLoader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                List<String> classNames = this.parse(url);
                for (String className : classNames) {
                    Class<T> klass = this.loadClassIfVisible(className, this.classLoader);
                    if (klass == null) continue;
                    T service = klass.newInstance();
                    services.add(service);
                }
            }
        }
        catch (IOException exc) {
            throw new NoServiceProviderException(exc);
        }
        catch (InstantiationException exc) {
            throw new NoServiceProviderException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new NoServiceProviderException(exc);
        }
        return services;
    }

    private <T> Class<T> loadClassIfVisible(String className, ClassLoader classLoader) {
        try {
            Class<?> klass = classLoader.loadClass(className);
            return klass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private List<String> parse(URL url) {
        InputStream is = null;
        BufferedReader reader = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            is = url.openStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.parseLine(names, line);
            }
            this.closeSilently(reader);
        }
        catch (IOException exc) {
            try {
                throw new NoServiceProviderException(exc);
            }
            catch (Throwable throwable) {
                this.closeSilently(reader);
                throw throwable;
            }
        }
        return names;
    }

    private void closeSilently(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseLine(List<String> names, String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            line = line.substring(0, commentPos);
        }
        if (!(line = line.trim()).isEmpty() && !names.contains(line)) {
            names.add(line);
        }
    }
}

