/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.mongo;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;
import org.apache.servicemix.store.base.BaseStoreFactory;
import org.apache.servicemix.store.mongo.MongoStore;

public class MongoStoreFactory
extends BaseStoreFactory {
    private Mongo mongo;
    private DB db;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String database;
    private Long timeout;
    private Map<String, MongoStore> stores = new HashMap<String, MongoStore>();

    public synchronized Store open(String collection) throws IOException {
        String key = this.database + "/" + collection;
        MongoStore store = this.stores.get(key);
        if (store == null) {
            boolean authenticated;
            if (this.mongo == null) {
                if (this.host == null || this.port == null) {
                    throw new IOException("MongoDB host and port are required.");
                }
                this.mongo = new Mongo(this.host, this.port.intValue());
            }
            if (this.db == null) {
                if (this.database == null) {
                    throw new IOException("MongoDB database name is required.");
                }
                this.db = this.mongo.getDB(this.database);
            }
            if (this.username != null && this.password != null && !(authenticated = this.db.authenticate(this.username, this.password.toCharArray()))) {
                throw new IOException("MongoDB authentication failed.");
            }
            store = this.timeout != null ? new MongoStore(this.db, collection, this.timeout) : new MongoStore(this.db, collection);
            for (StoreListener listener : this.storeListeners) {
                store.addListener(listener);
            }
            this.stores.put(key, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public void setMongo(Mongo mongo) {
        this.mongo = mongo;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}

