/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static String dumpModelAsXml(NamedNode definition) throws JAXBException {
        JAXBContext jaxbContext = ModelHelper.createJaxbContext();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        return buffer.toString();
    }

    public static <T extends NamedNode> T createModelFromXml(String xml, Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = ModelHelper.createJaxbContext();
        StringReader reader = new StringReader(xml);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object result = unmarshaller.unmarshal((Reader)reader);
        reader.close();
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to " + type + " using JAXB from XML: " + xml);
        }
        return (T)((NamedNode)type.cast(result));
    }

    public static <T extends NamedNode> T createModelFromXml(InputStream stream, Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = ModelHelper.createJaxbContext();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object result = unmarshaller.unmarshal(stream);
        return (T)((NamedNode)type.cast(result));
    }

    public static JAXBContext createJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer", (ClassLoader)CamelContext.class.getClassLoader());
    }
}

