/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.JsonSchemaLookup;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@ManagedResource(componentName="Endpoint", description="Responsible for managing server instances.")
public class ManagedEndpoint
implements ManagedComponent,
ServerLifeCycleListener {
    public static final String ENDPOINT_NAME = "managed.endpoint.name";
    public static final String SERVICE_NAME = "managed.service.name";
    public static final String INDENTION = "    ";
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedEndpoint.class);
    private final String eol = System.getProperty("line.separator");
    private Bus bus;
    private Endpoint endpoint;
    private Server server;
    private State state = State.CREATED;
    private ConfigurationAdmin configurationAdmin;

    public ManagedEndpoint(Bus b, Endpoint ep, Server s) {
        this.bus = b;
        this.endpoint = ep;
        this.server = s;
    }

    @ManagedOperation
    public void start() {
        if (this.state == State.STARTED) {
            return;
        }
        ServerLifeCycleManager mgr = this.bus.getExtension(ServerLifeCycleManager.class);
        if (mgr != null) {
            mgr.registerListener(this);
        }
        this.server.start();
    }

    @ManagedOperation
    public void stop() {
        this.server.stop();
    }

    @ManagedOperation
    public void destroy() {
        this.server.destroy();
    }

    @ManagedAttribute(description="Address Attribute", currencyTimeLimit=60)
    public String getAddress() {
        return this.endpoint.getEndpointInfo().getAddress();
    }

    @ManagedAttribute(description="TransportId Attribute", currencyTimeLimit=60)
    public String getTransportId() {
        return this.endpoint.getEndpointInfo().getTransportId();
    }

    @ManagedAttribute(description="Server State")
    public String getState() {
        return this.state.toString();
    }

    @ManagedAttribute(description="The cxf servlet context", currencyTimeLimit=60)
    public String getServletContext() {
        if (!this.isInOSGi()) {
            LOG.log(Level.FINE, "Not In OSGi.");
            return null;
        }
        String ret = "/cxf";
        if (this.getConfigurationAdmin() != null) {
            try {
                String servletContext;
                Dictionary properties;
                Configuration configuration = this.getConfigurationAdmin().getConfiguration("org.apache.cxf.osgi");
                if (configuration != null && (properties = configuration.getProperties()) != null && (servletContext = (String)configuration.getProperties().get("org.apache.cxf.servlet.context")) != null) {
                    ret = servletContext;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "getServletContext failed.", e);
            }
        }
        return ret;
    }

    @ManagedAttribute(description="if the endpoint has swagger doc or not", currencyTimeLimit=60)
    public boolean isSwagger() {
        if (!this.isWADL()) {
            return false;
        }
        List<Feature> features = this.server.getEndpoint().getActiveFeatures();
        if (features != null) {
            for (Feature feature : features) {
                if (!feature.getClass().getName().endsWith("SwaggerFeature")) continue;
                return true;
            }
        }
        return false;
    }

    @ManagedAttribute(description="if the endpoint has wsdl doc or not", currencyTimeLimit=60)
    public boolean isWSDL() {
        return !this.isWADL();
    }

    @ManagedAttribute(description="if the endpoint has WADL doc or not", currencyTimeLimit=60)
    public boolean isWADL() {
        return this.endpoint.getEndpointInfo().getBinding().getBindingId().equals("http://apache.org/cxf/binding/jaxrs");
    }

    @ManagedOperation(description="get the JSON schema from a given endpoint", currencyTimeLimit=60)
    public String getJSONSchema() {
        String ret = "";
        if (!this.isWSDL()) {
            Set resourceTypes = (Set)this.endpoint.get("jaxrs.resource.types");
            if (resourceTypes != null) {
                try {
                    ret = ret + this.getBeginIndentionWithReturn(1) + "\"" + "definitions" + "\" " + " : {" + this.getEol();
                    for (Class cls : resourceTypes) {
                        if (JsonSchemaLookup.getSingleton().getSchemaForClass(cls).length() <= 0) continue;
                        ret = ret + this.getIndention(2) + "\"" + cls.getName() + "\" : " + this.getEol();
                        ret = ret + this.rollbackEol(this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(cls), 3)) + "," + this.getEol();
                    }
                    ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturn(1);
                    ret = ret + this.getEndIndentionWithReturn(0);
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "getJSONSchema failed.", e);
                }
            }
        } else {
            try {
                for (ServiceInfo serviceInfo : this.endpoint.getService().getServiceInfos()) {
                    for (BindingInfo bindingInfo : serviceInfo.getBindings()) {
                        ret = ret + this.getBeginIndentionWithReturn(1) + "\"operations\" : " + this.getBeginIndentionWithReturn(0);
                        for (BindingOperationInfo boi : bindingInfo.getOperations()) {
                            ret = ret + this.getIndention(2) + "\"" + boi.getOperationInfo().getName().getLocalPart() + "\" " + " : " + this.getBeginIndentionWithReturn(3);
                            if (boi.getInput() != null && boi.getInput().getMessageParts() != null) {
                                ret = ret + "\"input\" : " + this.getBeginIndentionWithReturn(4) + "\"type\" : \"" + boi.getOperationInfo().getInput().getName().getLocalPart() + "\"" + this.getEndIndentionWithReturn(3) + "," + this.getEol();
                            }
                            if (boi.getOutput() != null && boi.getOutput().getMessageParts() != null) {
                                ret = ret + this.getIndention(3) + "\"output\" : " + this.getBeginIndentionWithReturn(4) + "\"type\" : \"" + boi.getOperationInfo().getOutput().getName().getLocalPart() + "\"" + this.getEndIndentionWithReturn(3);
                            }
                            ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturn(2) + "," + this.getEol();
                        }
                        if (ret.length() > 0) {
                            ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturn(1) + ",";
                        }
                        HashSet<String> addedType = new HashSet<String>();
                        ret = ret + this.getEol() + this.getIndention(1) + "\"definitions\" : " + this.getBeginIndentionWithReturn(0);
                        for (BindingOperationInfo boi : bindingInfo.getOperations()) {
                            Class<?> partClass;
                            if (boi.getInput() != null && boi.getInput().getMessageParts() != null && !addedType.contains(boi.getOperationInfo().getInput().getName().getLocalPart())) {
                                ret = ret + this.getIndention(2) + "\"" + boi.getOperationInfo().getInput().getName().getLocalPart() + "\" : " + this.getBeginIndentionWithReturnForList(0);
                                for (MessagePartInfo mpi : boi.getInput().getMessageParts()) {
                                    partClass = mpi.getTypeClass();
                                    if (partClass == null) continue;
                                    ret = ret + this.rollbackEol(this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3)) + "," + this.getEol();
                                }
                                ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturnForList(2) + "," + this.getEol();
                                addedType.add(boi.getOperationInfo().getInput().getName().getLocalPart());
                            }
                            if (boi.getOutput() == null || boi.getOutput().getMessageParts() == null || addedType.contains(boi.getOperationInfo().getOutput().getName().getLocalPart())) continue;
                            ret = ret + this.getIndention(2) + "\"" + boi.getOperationInfo().getOutput().getName().getLocalPart() + "\" : " + this.getBeginIndentionWithReturnForList(0);
                            for (MessagePartInfo mpi : boi.getOutput().getMessageParts()) {
                                partClass = mpi.getTypeClass();
                                if (partClass == null) continue;
                                ret = ret + this.rollbackEol(this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3)) + "," + this.getEol();
                            }
                            ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturnForList(2) + "," + this.getEol();
                            addedType.add(boi.getOperationInfo().getOutput().getName().getLocalPart());
                        }
                        if (ret.length() > 0) {
                            ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturn(1);
                        }
                        if (ret.length() <= 0) continue;
                        ret = this.rollbackColon(ret) + this.getEndIndentionWithReturn(0);
                    }
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "getJSONSchema failed.", e);
            }
        }
        return ret;
    }

    @ManagedOperation(description="get the JSON schema from a given class", currencyTimeLimit=60)
    public String getJSONSchemaForClass(String clsName) {
        String ret = "";
        if (!this.isWSDL()) {
            Set resourceTypes = (Set)this.endpoint.get("jaxrs.resource.types");
            if (resourceTypes != null) {
                try {
                    ret = ret + this.getBeginIndentionWithReturn(1) + "\"" + "definitions" + "\" " + " : {" + this.getEol();
                    for (Class cls : resourceTypes) {
                        if (!cls.getName().endsWith(clsName) || JsonSchemaLookup.getSingleton().getSchemaForClass(cls).length() <= 0) continue;
                        ret = ret + this.getIndention(2) + "\"" + cls.getName() + "\" : " + this.getEol();
                        ret = ret + this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(cls), 3);
                        ret = ret + this.getEol();
                    }
                    ret = ret + this.getEndIndentionWithReturn(1);
                    ret = ret + this.getEndIndentionWithReturn(0);
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "getJSONSchemaForClass failed.", e);
                }
            }
        } else {
            for (ServiceInfo serviceInfo : this.endpoint.getService().getServiceInfos()) {
                for (BindingInfo bindingInfo : serviceInfo.getBindings()) {
                    ret = ret + this.getBeginIndentionWithReturn(1) + "\"" + "definitions" + "\" " + " : {" + this.getEol();
                    for (BindingOperationInfo boi : bindingInfo.getOperations()) {
                        Class<?> partClass;
                        if (boi.getInput() != null && boi.getInput().getMessageParts() != null) {
                            for (MessagePartInfo mpi : boi.getInput().getMessageParts()) {
                                partClass = mpi.getTypeClass();
                                if (partClass == null || !partClass.getName().endsWith(clsName)) continue;
                                ret = ret + this.getIndention(2) + "\"" + partClass.getName() + "\" : " + this.getEol();
                                ret = ret + this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3);
                            }
                        }
                        if (boi.getOutput() == null || boi.getOutput().getMessageParts() == null) continue;
                        for (MessagePartInfo mpi : boi.getOutput().getMessageParts()) {
                            partClass = mpi.getTypeClass();
                            if (partClass == null || !partClass.getName().endsWith(clsName)) continue;
                            ret = ret + this.getIndention(2) + "\"" + partClass.getName() + "\" : " + this.getEol();
                            ret = ret + this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3);
                        }
                    }
                    ret = ret + this.getEndIndentionWithReturn(1);
                    ret = ret + this.getEndIndentionWithReturn(0);
                }
            }
        }
        return ret;
    }

    @ManagedOperation(description="get the JSON schema from a given soap endpoint for a given operation", currencyTimeLimit=60)
    public String getJSONSchemaForOperation(String operationName) {
        if (!this.isWSDL()) {
            return null;
        }
        String ret = "";
        for (ServiceInfo serviceInfo : this.endpoint.getService().getServiceInfos()) {
            for (BindingInfo bindingInfo : serviceInfo.getBindings()) {
                for (BindingOperationInfo boi : bindingInfo.getOperations()) {
                    Class<?> partClass;
                    if (!operationName.equals(boi.getOperationInfo().getName().getLocalPart())) continue;
                    ret = ret + this.getBeginIndentionWithReturn(1) + "\"" + boi.getOperationInfo().getName().getLocalPart() + "\" " + " : " + this.getBeginIndentionWithReturn(2);
                    if (boi.getInput() != null && boi.getInput().getMessageParts() != null) {
                        ret = ret + "\"input\" : " + this.getBeginIndentionWithReturn(4) + "\"type\" : \"" + boi.getOperationInfo().getInput().getName().getLocalPart() + "\"" + this.getEndIndentionWithReturn(2) + "," + this.getEol();
                    }
                    if (boi.getOutput() != null && boi.getOutput().getMessageParts() != null) {
                        ret = ret + this.getIndention(2) + "\"output\" : " + this.getBeginIndentionWithReturn(4) + "\"type\" : \"" + boi.getOperationInfo().getOutput().getName().getLocalPart() + "\"" + this.getEndIndentionWithReturn(2);
                    }
                    ret = this.rollbackColon(ret) + this.getEndIndentionWithReturn(1) + ",";
                    ret = ret + this.getEol() + this.getIndention(1) + "\"definitions\" : " + this.getBeginIndentionWithReturn(2);
                    if (boi.getInput() != null && boi.getInput().getMessageParts() != null) {
                        ret = ret + "\"" + boi.getOperationInfo().getInput().getName().getLocalPart() + "\" : " + this.getBeginIndentionWithReturnForList(0);
                        for (MessagePartInfo mpi : boi.getInput().getMessageParts()) {
                            partClass = mpi.getTypeClass();
                            if (partClass == null) continue;
                            ret = ret + this.rollbackEol(this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3)) + "," + this.getEol();
                        }
                        ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturnForList(2) + "," + this.getEol();
                    }
                    if (boi.getOutput() == null || boi.getOutput().getMessageParts() == null) continue;
                    ret = ret + this.getIndention(2) + "\"" + boi.getOperationInfo().getOutput().getName().getLocalPart() + "\" : " + this.getBeginIndentionWithReturnForList(0);
                    for (MessagePartInfo mpi : boi.getOutput().getMessageParts()) {
                        partClass = mpi.getTypeClass();
                        if (partClass == null) continue;
                        ret = ret + this.rollbackEol(this.reformatIndent(JsonSchemaLookup.getSingleton().getSchemaForClass(partClass), 3)) + "," + this.getEol();
                    }
                    ret = this.rollbackColon(this.rollbackEol(ret)) + this.getEndIndentionWithReturnForList(2) + ",";
                }
                if (ret.length() > 0) {
                    ret = this.rollbackColon(ret) + this.getEndIndentionWithReturn(1);
                }
                if (ret.length() <= 0) continue;
                ret = this.rollbackColon(ret) + this.getEndIndentionWithReturn(0);
            }
        }
        return ret;
    }

    @ManagedOperation(description="get the package name for a given namespace URI", currencyTimeLimit=60)
    public String getPackageNameByNameSpaceURI(String nameSpaceURI) {
        return PackageUtils.getPackageNameByNameSpaceURI(nameSpaceURI);
    }

    @ManagedOperation(description="get xml payload from json payload", currencyTimeLimit=60)
    public String jsonToXml(String jsonText, String pojoType) {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        try {
            Object pojo = objectMapper.readValue(jsonText, this.findClass(pojoType));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.findClass(pojoType)});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(pojo, (Writer)sw);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "jsonToXml failed.", e);
        }
        return sw.toString();
    }

    private Class<?> findClass(String clsName) {
        if (!this.isWSDL()) {
            Set resourceTypes = (Set)this.endpoint.get("jaxrs.resource.types");
            if (resourceTypes != null) {
                try {
                    for (Class cls : resourceTypes) {
                        if (!cls.getName().endsWith(clsName)) continue;
                        return cls;
                    }
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "findClass failed.", e);
                }
            }
        } else {
            for (ServiceInfo serviceInfo : this.endpoint.getService().getServiceInfos()) {
                for (BindingInfo bindingInfo : serviceInfo.getBindings()) {
                    for (BindingOperationInfo boi : bindingInfo.getOperations()) {
                        Class<?> partClass;
                        if (boi.getInput() != null && boi.getInput().getMessageParts() != null) {
                            for (MessagePartInfo mpi : boi.getInput().getMessageParts()) {
                                partClass = mpi.getTypeClass();
                                if (partClass == null || !partClass.getName().endsWith(clsName)) continue;
                                return partClass;
                            }
                        }
                        if (boi.getOutput() == null || boi.getOutput().getMessageParts() == null) continue;
                        for (MessagePartInfo mpi : boi.getOutput().getMessageParts()) {
                            partClass = mpi.getTypeClass();
                            if (partClass == null || !partClass.getName().endsWith(clsName)) continue;
                            return partClass;
                        }
                    }
                }
            }
        }
        return null;
    }

    private String reformatIndent(String input, int startIndent) {
        String ret = "";
        BufferedReader reader = new BufferedReader(new StringReader(input));
        try {
            String oneLine;
            while ((oneLine = reader.readLine()) != null) {
                ret = ret + this.getIndention(startIndent) + oneLine + this.getEol();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "reformatIndent failed.", e);
        }
        return ret;
    }

    private String rollbackEol(String input) {
        String ret = input;
        if (ret.endsWith(this.getEol())) {
            ret = ret.substring(0, ret.length() - this.getEol().length());
        }
        return ret;
    }

    private String rollbackColon(String input) {
        String ret = input;
        if (ret.endsWith(",")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private boolean isInOSGi() {
        return FrameworkUtil.getBundle(ManagedEndpoint.class) != null;
    }

    private String getBeginIndentionWithReturn(int n) {
        return "{" + this.getEol() + this.getIndention(n);
    }

    private String getEndIndentionWithReturn(int n) {
        return this.getEol() + this.getIndention(n) + "}";
    }

    private String getBeginIndentionWithReturnForList(int n) {
        return "[" + this.getEol() + this.getIndention(n);
    }

    private String getEndIndentionWithReturnForList(int n) {
        return this.getEol() + this.getIndention(n) + "]";
    }

    private String getIndention(int n) {
        String ret = "";
        for (int i = 0; i < n; ++i) {
            ret = ret + INDENTION;
        }
        return ret;
    }

    private String getEol() {
        if (this.eol == null) {
            return "\n";
        }
        return this.eol;
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        try {
            ServiceReference serviceReference;
            BundleContext bundleContext;
            if (this.isInOSGi() && this.configurationAdmin == null && (bundleContext = FrameworkUtil.getBundle(ManagedEndpoint.class).getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName())) != null) {
                this.configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "getConfigurationAdmin failed.", e);
        }
        return this.configurationAdmin;
    }

    @Override
    public ObjectName getObjectName() throws JMException {
        String busId = this.bus.getId();
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf").append(':');
        buffer.append("bus.id").append('=').append(busId).append(',');
        buffer.append("type").append('=').append("Bus.Service.Endpoint,");
        String serviceName = (String)this.endpoint.get(SERVICE_NAME);
        if (StringUtils.isEmpty(serviceName)) {
            serviceName = this.endpoint.getService().getName().toString();
        }
        serviceName = ObjectName.quote(serviceName);
        buffer.append("service").append('=').append(serviceName).append(',');
        String endpointName = (String)this.endpoint.get(ENDPOINT_NAME);
        if (StringUtils.isEmpty(endpointName)) {
            endpointName = this.endpoint.getEndpointInfo().getName().getLocalPart();
        }
        endpointName = ObjectName.quote(endpointName);
        buffer.append("port").append('=').append(endpointName).append(',');
        buffer.append("instance.id").append('=').append(this.endpoint.hashCode());
        return new ObjectName(buffer.toString());
    }

    @Override
    public void startServer(Server s) {
        if (this.server.equals(s)) {
            this.state = State.STARTED;
        }
    }

    @Override
    public void stopServer(Server s) {
        if (this.server.equals(s)) {
            this.state = State.STOPPED;
            ServerLifeCycleManager mgr = this.bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.unRegisterListener(this);
            }
        }
    }

    private static enum State {
        CREATED,
        STARTED,
        STOPPED;

    }
}

