/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.chm;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import net.sf.ehcache.store.chm.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableConcurrentHashMap
extends ConcurrentHashMap<Object, Element> {
    private static final Element DUMMY_PINNED_ELEMENT = new Element(new DummyPinnedKey(), new DummyPinnedValue());
    private final Random rndm = new Random();
    private final PoolAccessor poolAccessor;
    private final boolean elementPinningEnabled;
    private volatile long maxSize;
    private volatile PinnedKeySet pinnedKeySet;
    private final RegisteredEventListeners cacheEventNotificationService;

    public SelectableConcurrentHashMap(PoolAccessor poolAccessor, boolean elementPinningEnabled, int initialCapacity, float loadFactor, int concurrency, long maximumSize, RegisteredEventListeners cacheEventNotificationService) {
        super(initialCapacity, loadFactor, concurrency);
        this.poolAccessor = poolAccessor;
        this.elementPinningEnabled = elementPinningEnabled;
        this.maxSize = maximumSize;
        this.cacheEventNotificationService = cacheEventNotificationService;
        this.pinnedKeySet = new PinnedKeySet();
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public Element[] getRandomValues(int size, Object keyHint) {
        ArrayList<Element> sampled = new ArrayList<Element>(size * 2);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift & this.segmentMask : SelectableConcurrentHashMap.hash(keyHint.hashCode()) >>> this.segmentShift & this.segmentMask;
        int segmentIndex = segmentStart;
        do {
            int tableStart;
            ConcurrentHashMap.HashEntry<K, V>[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                ConcurrentHashMap.HashEntry e = table[tableIndex];
                while (e != null) {
                    Element value = (Element)e.value;
                    MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)e;
                    if (!(value == null || !value.isExpired() && mshe.pinned && this.elementPinningEnabled)) {
                        sampled.add(value);
                    }
                    e = e.next;
                }
                if (sampled.size() < size) continue;
                return sampled.toArray(new Element[sampled.size()]);
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled.toArray(new Element[sampled.size()]);
    }

    public Object storedObject(Element e) {
        return new MemoryStoreHashEntry(null, 0, null, e, 0L, false);
    }

    public int quickSize() {
        ConcurrentHashMap.Segment[] segments = this.segments;
        long sum = 0L;
        for (ConcurrentHashMap.Segment seg : segments) {
            sum += (long)(seg.count - ((MemoryStoreSegment)seg).numDummyPinnedKeys);
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int i;
        ConcurrentHashMap.Segment[] segments = this.segments;
        for (int k = 0; k < 2; ++k) {
            int i2;
            int[] mc = new int[segments.length];
            long check = 0L;
            long sum = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)(segments[i2].count - ((MemoryStoreSegment)segments[i2]).numDummyPinnedKeys);
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check += (long)(segments[i2].count - ((MemoryStoreSegment)segments[i2]).numDummyPinnedKeys);
                    if (mc[i2] == segments[i2].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check != sum) continue;
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }
        long sum = 0L;
        for (i = 0; i < segments.length; ++i) {
            segments[i].readLock().lock();
        }
        try {
            for (i = 0; i < segments.length; ++i) {
                sum += (long)(segments[i].count - ((MemoryStoreSegment)segments[i]).numDummyPinnedKeys);
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pinnedSize() {
        int i;
        ConcurrentHashMap.Segment[] segments = this.segments;
        for (int k = 0; k < 2; ++k) {
            int i2;
            int[] mc = new int[segments.length];
            long check = 0L;
            long sum = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)(((MemoryStoreSegment)segments[i2]).pinnedCount - ((MemoryStoreSegment)segments[i2]).numDummyPinnedKeys);
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check += (long)(((MemoryStoreSegment)segments[i2]).pinnedCount - ((MemoryStoreSegment)segments[i2]).numDummyPinnedKeys);
                    if (mc[i2] == segments[i2].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check != sum) continue;
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }
        long sum = 0L;
        for (i = 0; i < segments.length; ++i) {
            segments[i].readLock().lock();
        }
        try {
            for (i = 0; i < segments.length; ++i) {
                sum += (long)(((MemoryStoreSegment)segments[i]).pinnedCount - ((MemoryStoreSegment)segments[i]).numDummyPinnedKeys);
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public ReentrantReadWriteLock lockFor(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash);
    }

    public ReentrantReadWriteLock[] locks() {
        return this.segments;
    }

    @Override
    public Element put(Object key, Element value) {
        return this.put(key, value, 0L);
    }

    @Override
    public Element putIfAbsent(Object key, Element value) {
        return this.putIfAbsent(key, value, 0L);
    }

    public Element put(Object key, Element element, long sizeOf) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return ((MemoryStoreSegment)this.segmentFor(hash)).put(key, hash, element, sizeOf, false);
    }

    public Element putIfAbsent(Object key, Element element, long sizeOf) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return ((MemoryStoreSegment)this.segmentFor(hash)).put(key, hash, element, sizeOf, true);
    }

    public void unpinAll() {
        for (ConcurrentHashMap.Segment segment : this.segments) {
            MemoryStoreSegment mss = (MemoryStoreSegment)segment;
            mss.unpinAll();
        }
    }

    public void setPinned(Object key, boolean pinned) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        ((MemoryStoreSegment)this.segmentFor(hash)).setPinned(key, pinned, hash);
    }

    public boolean isPinned(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return ((MemoryStoreSegment)this.segmentFor(hash)).isPinned(key, hash);
    }

    @Override
    public Set<Object> keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Element> values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<Object, Element>> entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    protected ConcurrentHashMap.Segment<Object, Element> createSegment(int initialCapacity, float lf) {
        return new MemoryStoreSegment(initialCapacity, lf);
    }

    public boolean evict() {
        return this.getRandomSegment().evict();
    }

    private MemoryStoreSegment getRandomSegment() {
        int randomHash = this.rndm.nextInt();
        return (MemoryStoreSegment)this.segments[randomHash >>> this.segmentShift & this.segmentMask];
    }

    public void recalculateSize(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        ((MemoryStoreSegment)this.segmentFor(hash)).recalculateSize(key, hash);
    }

    public Set pinnedKeySet() {
        PinnedKeySet pks = this.pinnedKeySet;
        return pks != null ? pks : (this.pinnedKeySet = new PinnedKeySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PinnedKeyIterator
    extends KeyIterator {
        private PinnedKeyIterator() {
        }

        @Override
        protected boolean hideValue(ConcurrentHashMap.HashEntry<Object, Element> hashEntry) {
            return super.hideValue(hashEntry) || !((MemoryStoreHashEntry)hashEntry).pinned;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PinnedKeySet
    extends AbstractSet<Object> {
        private PinnedKeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new PinnedKeyIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.pinnedSize();
        }

        @Override
        public boolean contains(Object o) {
            return SelectableConcurrentHashMap.this.isPinned(o) && SelectableConcurrentHashMap.this.containsKey(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashEntryIterator
    extends ConcurrentHashMap.HashIterator {
        private ConcurrentHashMap.HashEntry<Object, Element> myNextEntry = this.advanceToNextEntry();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        public ConcurrentHashMap.HashEntry<Object, Element> nextEntry() {
            if (this.myNextEntry == null) {
                throw new NoSuchElementException();
            }
            ConcurrentHashMap.HashEntry<Object, Element> entry = this.myNextEntry;
            this.myNextEntry = this.advanceToNextEntry();
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.myNextEntry != null;
        }

        private ConcurrentHashMap.HashEntry<Object, Element> advanceToNextEntry() {
            ConcurrentHashMap.HashEntry<Object, Element> myEntry = null;
            while (super.hasNext() && ((myEntry = super.nextEntry()) == null || this.hideValue(myEntry))) {
                myEntry = null;
            }
            return myEntry;
        }

        protected boolean hideValue(ConcurrentHashMap.HashEntry<Object, Element> hashEntry) {
            MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)hashEntry;
            return mshe.value == DUMMY_PINNED_ELEMENT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashEntryIterator
    implements Iterator<Map.Entry<Object, Element>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<Object, Element> next() {
            ConcurrentHashMap.HashEntry<Object, Element> entry = this.nextEntry();
            final Object key = entry.key;
            final Element value = (Element)entry.value;
            return new Map.Entry<Object, Element>(){

                @Override
                public Object getKey() {
                    return key;
                }

                @Override
                public Element getValue() {
                    return value;
                }

                @Override
                public Element setValue(Element value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashEntryIterator
    implements Iterator<Element> {
        ValueIterator() {
        }

        @Override
        public Element next() {
            return (Element)this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends HashEntryIterator
    implements Iterator<Object> {
        KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<Object, Element>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Element>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Element v = (Element)SelectableConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SelectableConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Map.Entry<Object, Element>> c = new ArrayList<Map.Entry<Object, Element>>();
            for (Map.Entry<Object, Element> object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Map.Entry<Object, Element>> c = new ArrayList<Map.Entry<Object, Element>>();
            for (Map.Entry<Object, Element> object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<Element> {
        Values() {
        }

        @Override
        public Iterator<Element> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SelectableConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Element> c = new ArrayList<Element>();
            for (Element object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Element> c = new ArrayList<Element>();
            for (Element object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SelectableConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return SelectableConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    @IgnoreSizeOf
    private static class DummyPinnedValue
    implements Serializable {
        private DummyPinnedValue() {
        }
    }

    @IgnoreSizeOf
    private static class DummyPinnedKey
    implements Serializable {
        private DummyPinnedKey() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemoryStoreHashEntryIterator
    implements Iterator<MemoryStoreHashEntry> {
        int nextTableIndex = -1;
        ConcurrentHashMap.HashEntry[] currentTable;
        MemoryStoreHashEntry nextEntry;
        MemoryStoreHashEntry lastReturned;
        private final MemoryStoreSegment seg;

        private MemoryStoreHashEntryIterator(MemoryStoreSegment memoryStoreSegment) {
            this.seg = memoryStoreSegment;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public MemoryStoreHashEntry next() {
            if (this.nextEntry == null) {
                return null;
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = (MemoryStoreHashEntry)this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = (MemoryStoreHashEntry)this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            if (this.seg.count != 0) {
                this.currentTable = this.seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = (MemoryStoreHashEntry)this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MemoryStoreHashEntry
    extends ConcurrentHashMap.HashEntry<Object, Element> {
        volatile boolean pinned;
        volatile long sizeOf;
        volatile boolean accessed = true;

        private MemoryStoreHashEntry(Object key, int hash, ConcurrentHashMap.HashEntry<Object, Element> next, Element value, long sizeOf, boolean pinned) {
            super(key, hash, next, value);
            this.sizeOf = sizeOf;
            this.pinned = pinned;
        }

        public void setPinned(boolean pinned) {
            this.pinned = pinned;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MemoryStoreSegment
    extends ConcurrentHashMap.Segment<Object, Element> {
        private static final int MAX_EVICTION = 5;
        private Iterator<MemoryStoreHashEntry> evictionIterator;
        private boolean fullyPinned;
        private volatile int pinnedCount;
        private volatile int numDummyPinnedKeys;

        private MemoryStoreSegment(int initialCapacity, float lf) {
            super(initialCapacity, lf);
            this.evictionIterator = this.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateEmptyPinnedKeySize(boolean pinned, MemoryStoreHashEntry mshe) {
            this.writeLock().lock();
            try {
                if (mshe == null && pinned) {
                    ++this.pinnedCount;
                    ++this.numDummyPinnedKeys;
                    return;
                }
                if (pinned) {
                    ++this.pinnedCount;
                    return;
                }
                if (mshe == null || !mshe.pinned && !pinned) {
                    return;
                }
                if (pinned) {
                    ++this.pinnedCount;
                    ++this.numDummyPinnedKeys;
                } else {
                    --this.pinnedCount;
                    --this.numDummyPinnedKeys;
                }
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPinned(Object key, boolean pinned, int hash) {
            this.writeLock().lock();
            try {
                ConcurrentHashMap.HashEntry first;
                ConcurrentHashMap.HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                ConcurrentHashMap.HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                MemoryStoreHashEntry mshe = null;
                if (e != null) {
                    mshe = (MemoryStoreHashEntry)e;
                    mshe.setPinned(pinned);
                } else if (pinned) {
                    this.putInternal(key, hash, DUMMY_PINNED_ELEMENT, 0L, false, true);
                }
                this.calculateEmptyPinnedKeySize(pinned, mshe);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPinned(Object key, int hash) {
            this.readLock().lock();
            try {
                ConcurrentHashMap.HashEntry first;
                ConcurrentHashMap.HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                ConcurrentHashMap.HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    boolean bl = ((MemoryStoreHashEntry)e).pinned;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unpinAll() {
            this.writeLock().lock();
            try {
                if (this.numDummyPinnedKeys == this.count) {
                    this.clear();
                    return;
                }
                Iterator<MemoryStoreHashEntry> itr = this.iterator();
                int dummyPinnedKeys = 0;
                for (int numVisited = 0; itr.hasNext() && numVisited < this.count; ++numVisited) {
                    MemoryStoreHashEntry mshe = itr.next();
                    if (mshe.pinned && mshe.value == DUMMY_PINNED_ELEMENT) {
                        ++dummyPinnedKeys;
                    }
                    mshe.setPinned(false);
                }
                this.pinnedCount = this.numDummyPinnedKeys = dummyPinnedKeys;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        @Override
        protected ConcurrentHashMap.HashEntry<Object, Element> relinkHashEntry(ConcurrentHashMap.HashEntry<Object, Element> e, ConcurrentHashMap.HashEntry<Object, Element> next) {
            if (e instanceof MemoryStoreHashEntry) {
                MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)e;
                return new MemoryStoreHashEntry(mshe.key, mshe.hash, next, (Element)mshe.value, mshe.sizeOf, mshe.pinned);
            }
            return new ConcurrentHashMap.HashEntry<Object, Element>(e.key, e.hash, next, (Element)e.value);
        }

        @Override
        void clear() {
            super.clear();
            this.numDummyPinnedKeys = 0;
            this.pinnedCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Element remove(Object key, int hash, Object value) {
            this.writeLock().lock();
            try {
                ConcurrentHashMap.HashEntry<Object, Element> first;
                int c = this.count - 1;
                ConcurrentHashMap.HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                ConcurrentHashMap.HashEntry<Object, Element> e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                Element oldValue = null;
                if (e != null) {
                    Element v = (Element)e.value;
                    MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)e;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        if (!mshe.pinned) {
                            ConcurrentHashMap.HashEntry<Object, Element> newFirst = e.next;
                            ConcurrentHashMap.HashEntry<Object, Element> p = first;
                            while (p != e) {
                                newFirst = this.relinkHashEntry(p, newFirst);
                                p = p.next;
                            }
                            tab[index] = newFirst;
                        } else {
                            ++c;
                            mshe.value = DUMMY_PINNED_ELEMENT;
                            if (oldValue == DUMMY_PINNED_ELEMENT) {
                                oldValue = null;
                            } else {
                                ++this.numDummyPinnedKeys;
                            }
                        }
                        this.count = c;
                        SelectableConcurrentHashMap.this.poolAccessor.delete(mshe.sizeOf);
                    }
                }
                Element element = oldValue;
                return element;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        Element put(Object key, int hash, Element value, long sizeOf, boolean onlyIfAbsent) {
            return this.putInternal(key, hash, value, sizeOf, onlyIfAbsent, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recalculateSize(Object key, int hash) {
            Element value = null;
            long oldSize = 0L;
            this.readLock().lock();
            try {
                ConcurrentHashMap.HashEntry first;
                ConcurrentHashMap.HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                ConcurrentHashMap.HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)e;
                    key = mshe.key;
                    value = (Element)mshe.value;
                    oldSize = mshe.sizeOf;
                }
            }
            finally {
                this.readLock().unlock();
            }
            if (value != null) {
                long delta = SelectableConcurrentHashMap.this.poolAccessor.replace(oldSize, key, value, SelectableConcurrentHashMap.this.storedObject(value), true);
                this.writeLock().lock();
                try {
                    ConcurrentHashMap.HashEntry first;
                    ConcurrentHashMap.HashEntry[] tab = this.table;
                    int index = hash & tab.length - 1;
                    ConcurrentHashMap.HashEntry e = first = tab[index];
                    while (e != null && key != e.key) {
                        e = e.next;
                    }
                    if (e != null && e.value == value && oldSize == ((MemoryStoreHashEntry)e).sizeOf) {
                        ((MemoryStoreHashEntry)e).sizeOf = oldSize + delta;
                    } else {
                        SelectableConcurrentHashMap.this.poolAccessor.delete(delta);
                    }
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Element putInternal(Object key, int hash, Element value, long sizeOf, boolean onlyIfAbsent, boolean pinned) {
            Element[] evicted = new Element[5];
            this.writeLock().lock();
            try {
                Element oldValue;
                ConcurrentHashMap.HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                ConcurrentHashMap.HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                ConcurrentHashMap.HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = (Element)e.value;
                    if (e.value == DUMMY_PINNED_ELEMENT || !onlyIfAbsent) {
                        MemoryStoreHashEntry mshe = (MemoryStoreHashEntry)e;
                        SelectableConcurrentHashMap.this.poolAccessor.delete(mshe.sizeOf);
                        e.value = value;
                        mshe.sizeOf = sizeOf;
                        if (oldValue == DUMMY_PINNED_ELEMENT && value != DUMMY_PINNED_ELEMENT) {
                            --this.numDummyPinnedKeys;
                            oldValue = null;
                        }
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new MemoryStoreHashEntry(key, hash, first, value, sizeOf, pinned);
                    this.count = c;
                }
                if (!pinned && (onlyIfAbsent && oldValue != null || !onlyIfAbsent)) {
                    if (!this.isPinned(key, hash)) {
                        this.fullyPinned = false;
                    }
                    if (!this.fullyPinned && SelectableConcurrentHashMap.this.maxSize > 0L) {
                        int runs = Math.min(5, SelectableConcurrentHashMap.this.quickSize() - (int)SelectableConcurrentHashMap.this.maxSize);
                        while (runs-- > 0) {
                            Element removed;
                            Element evict = this.nextExpiredOrToEvict(value);
                            if (evict == null) continue;
                            while ((removed = this.remove(evict.getKey(), ConcurrentHashMap.hash(evict.getKey().hashCode()), null)) == null && (evict = this.nextExpiredOrToEvict(value)) != null) {
                            }
                            evicted[runs] = removed;
                        }
                    }
                }
                Element element = oldValue;
                return element;
            }
            finally {
                this.writeLock().unlock();
                for (Element element : evicted) {
                    this.notifyEvictionOrExpiry(element);
                }
            }
        }

        private void notifyEvictionOrExpiry(Element element) {
            if (element != null && SelectableConcurrentHashMap.this.cacheEventNotificationService != null) {
                if (element.isExpired()) {
                    SelectableConcurrentHashMap.this.cacheEventNotificationService.notifyElementExpiry(element, false);
                } else {
                    SelectableConcurrentHashMap.this.cacheEventNotificationService.notifyElementEvicted(element, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Element get(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    ConcurrentHashMap.HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key) && !((Element)e.value).equals(DUMMY_PINNED_ELEMENT)) {
                            ((MemoryStoreHashEntry)e).accessed = true;
                            Element element = (Element)e.value;
                            return element;
                        }
                        e = e.next;
                    }
                }
                Element element = null;
                return element;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean containsKey(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    ConcurrentHashMap.HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key) && !((Element)e.value).equals(DUMMY_PINNED_ELEMENT)) {
                            boolean bl = true;
                            return bl;
                        }
                        e = e.next;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        private Element nextExpiredOrToEvict(Element justAdded) {
            Element lastUnpinned = null;
            int i = 0;
            while (!this.fullyPinned && i++ < this.count) {
                if (!this.evictionIterator.hasNext()) {
                    this.evictionIterator = this.iterator();
                }
                MemoryStoreHashEntry next = this.evictionIterator.next();
                if (((Element)next.value).isExpired() || !next.accessed) {
                    return (Element)next.value;
                }
                boolean pinned = next.pinned;
                if (!pinned && next.value != justAdded) {
                    lastUnpinned = (Element)next.value;
                }
                next.accessed = pinned;
            }
            this.fullyPinned = !this.fullyPinned && i >= this.count && lastUnpinned == null;
            return lastUnpinned;
        }

        private Iterator<MemoryStoreHashEntry> iterator() {
            return new MemoryStoreHashEntryIterator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean evict() {
            Element remove = null;
            this.writeLock().lock();
            try {
                Element evict = this.nextExpiredOrToEvict(null);
                if (evict != null) {
                    remove = this.remove(evict.getKey(), ConcurrentHashMap.hash(evict.getKey().hashCode()), null);
                }
            }
            finally {
                this.writeLock().unlock();
            }
            this.notifyEvictionOrExpiry(remove);
            return remove != null;
        }
    }
}

