/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.client.spec.ClientResponseContextImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;

public class ClientResponseFilterInterceptor
extends AbstractInDatabindingInterceptor {
    public ClientResponseFilterInterceptor() {
        super("pre-protocol-frontend");
    }

    public void handleMessage(Message inMessage) throws Fault {
        ProviderFactory pf = ProviderFactory.getInstance(inMessage);
        if (pf == null) {
            return;
        }
        List<ProviderInfo<ClientResponseFilter>> filters = pf.getClientResponseFilters();
        if (!filters.isEmpty()) {
            ClientRequestContextImpl reqContext = new ClientRequestContextImpl(inMessage.getExchange().getInMessage(), true);
            ClientResponseContextImpl respContext = new ClientResponseContextImpl(this.getResponse(inMessage), inMessage);
            for (ProviderInfo<ClientResponseFilter> filter : filters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, inMessage);
                try {
                    filter.getProvider().filter((ClientRequestContext)reqContext, (ClientResponseContext)respContext);
                }
                catch (IOException ex) {
                    throw new ClientException((Throwable)ex);
                }
            }
        }
    }

    protected Response getResponse(Message inMessage) {
        Response resp = (Response)inMessage.getExchange().get(Response.class);
        if (resp != null) {
            return resp;
        }
        Response.ResponseBuilder rb = Response.status((int)((Integer)inMessage.get((Object)Message.RESPONSE_CODE)));
        rb.entity(inMessage.get(InputStream.class));
        Map protocolHeaders = (Map)inMessage.get((Object)Message.PROTOCOL_HEADERS);
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            for (String val : (List)entry.getValue()) {
                rb.header((String)entry.getKey(), (Object)val);
            }
        }
        return rb.build();
    }
}

