/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Strings {
    public static boolean notEmpty(String text) {
        return text != null && text.length() > 0;
    }

    public static String nullIfEmpty(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String emptyIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return Strings.notEmpty(value) ? value : defaultValue;
    }

    public static List<String> splitAsList(String text, String delimiter) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            answer.addAll(Arrays.asList(text.split(delimiter)));
        }
        return answer;
    }

    public static List<String> splitAndTrimAsList(String text, String sep) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            for (String v : text.split(sep)) {
                String trim = v.trim();
                if (trim.length() <= 0) continue;
                answer.add(trim);
            }
        }
        return answer;
    }

    public static String join(Collection<?> collection, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object next : collection) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(next);
        }
        return buffer.toString();
    }

    public static String join(String separator, Object ... objects) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static String joinNotNull(String separator, Object ... objects) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object object : objects) {
            if (object == null) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object).toString();
        }
        return object.toString();
    }

    public static String unquote(String text) {
        if (text != null && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isNotBlank(String text) {
        return !Strings.isNullOrBlank(text);
    }
}

