/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.switchyard.HandlerException;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.transaction.TransactionManagerLocator;

public class TransactionHelper {
    private static final Logger LOGGER = Logger.getLogger(TransactionHelper.class);
    public static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    public static final String JNDI_USER_TRANSACTION = "java:jboss/UserTransaction";
    private final boolean _enabled;
    private UserTransaction _userTx = null;
    private boolean _isInitiator = false;

    public TransactionHelper(boolean enabled) {
        this._enabled = enabled;
    }

    public void begin() throws HandlerException {
        if (this._enabled) {
            try {
                this._userTx = TransactionManagerLocator.INSTANCE.getUserTransaction();
                if (this._userTx.getStatus() == 6) {
                    this._userTx.begin();
                    this._isInitiator = true;
                }
            }
            catch (SystemException se) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionBeginFailedSystem(se);
            }
            catch (NotSupportedException nse) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionBeginFailedNSE(nse);
            }
        }
    }

    public void commit() throws HandlerException {
        if (this._isInitiator) {
            try {
                this._userTx.commit();
            }
            catch (SystemException se) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionCommitFailedSystem(se);
            }
            catch (HeuristicRollbackException hre) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionCommitFailedRollback(hre);
            }
            catch (HeuristicMixedException hme) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionCommitFailedMixed(hme);
            }
            catch (RollbackException re) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionCommitFailed(re);
            }
        }
    }

    public void rollback() throws HandlerException {
        if (this._isInitiator) {
            try {
                this._userTx.rollback();
            }
            catch (SystemException se) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionRollbackFailed(se);
            }
        }
        if (this._userTx != null) {
            try {
                this._userTx.setRollbackOnly();
            }
            catch (SystemException se) {
                throw CommonKnowledgeMessages.MESSAGES.userTransactionSetRollbackOnlyFailed(se);
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return TransactionHelper.getTransactionManager(null);
    }

    public static TransactionManager getTransactionManager(Properties properties) {
        return (TransactionManager)TransactionHelper.jndiLookup(JNDI_TRANSACTION_MANAGER, properties);
    }

    public static UserTransaction getUserTransaction() {
        return (UserTransaction)TransactionHelper.jndiLookup(JNDI_USER_TRANSACTION, null);
    }

    private static Object jndiLookup(String name, Properties properties) {
        InitialContext ctx = null;
        try {
            ctx = properties != null ? new InitialContext(properties) : new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (NamingException ne) {
            LOGGER.error((Object)ne.getMessage());
            throw new RuntimeException(ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOGGER.error((Object)t.getMessage());
                }
            }
        }
    }
}

