/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.integration.fuse.config;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Text;
import java.util.Arrays;
import java.util.List;
import org.jboss.fuse.eap.config.ConfigEditor;
import org.jboss.fuse.eap.config.ConfigSupport;
import org.jboss.fuse.eap.config.LayerConfig;

public class FuseIntegrationConfigEditor
implements ConfigEditor {
    @Override
    public void applyStandaloneConfigChange(boolean enable, Document doc) {
        FuseIntegrationConfigEditor.updateSwitchyardModules(enable, doc);
    }

    @Override
    public void applyDomainConfigChange(boolean enable, Document doc) {
        this.applyStandaloneConfigChange(enable, doc);
    }

    public static void updateSwitchyardModules(boolean enable, Document doc) {
        List<Element> profiles = ConfigSupport.findProfileElements(doc);
        for (Element profile : profiles) {
            Element switchyard = ConfigSupport.findElementWithStartingAttributeValue(profile.getChildren("subsystem"), "xmlns", "urn:jboss:domain:switchyard:");
            ConfigSupport.assertExists(switchyard, "Did not find the switchyard subsystem");
            Element modules = switchyard.getChild("modules");
            ConfigSupport.assertExists(modules, "Did not find the <modules> element");
            FuseIntegrationConfigEditor.updateSwitchyardModule(enable, modules, "org.switchyard.component.bpm", "org.switchyard.component.bpm.deploy.BPMComponent");
            FuseIntegrationConfigEditor.updateSwitchyardModule(enable, modules, "org.switchyard.component.rules", "org.switchyard.component.rules.deploy.RulesComponent");
        }
    }

    private static void updateSwitchyardModule(boolean enable, Element modules, String id, String className) {
        Element module = ConfigSupport.findElementWithAttributeValue(modules.getChildren("module"), "identifier", id);
        if (enable && module == null) {
            modules.addNodes(new Text("    "), new Element("module").addAttribute("identifier", id).addAttribute("implClass", className), new Text("\n            "));
        }
        if (!enable && module != null) {
            module.remove();
        }
    }

    @Override
    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(new LayerConfig("fuse", LayerConfig.Type.REQUIRED, -10), new LayerConfig("bpms", LayerConfig.Type.INSTALLING, -9), new LayerConfig("soa", LayerConfig.Type.REQUIRED, -8));
    }
}

