/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.integration.fuse.config;

import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.wildfly.extension.camel.config.ConfigContext;
import org.wildfly.extension.camel.config.ConfigPlugin;
import org.wildfly.extension.camel.config.ConfigSupport;
import org.wildfly.extension.camel.config.LayerConfig;
import org.wildfly.extension.camel.config.WildFlyCamelConfigPlugin;

public class FuseIntegrationConfigPlugin
implements ConfigPlugin {
    private static final Namespace NS_SWITCHYARD = Namespace.getNamespace((String)"urn:jboss:domain:switchyard:1.0");

    public String getConfigName() {
        return "bpms";
    }

    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(new LayerConfig("fuse", LayerConfig.Type.REQUIRED, -10), new LayerConfig("bpms", LayerConfig.Type.INSTALLING, -9), new LayerConfig("soa", LayerConfig.Type.REQUIRED, -8), new LayerConfig("fuse-integration", LayerConfig.Type.INSTALLING, -7));
    }

    public void applyDomainConfigChange(ConfigContext context, boolean enable) {
    }

    public void applyStandaloneConfigChange(ConfigContext context, boolean enable) {
        FuseIntegrationConfigPlugin.updateSwitchyardModules(enable, context);
    }

    public static void updateSwitchyardModules(boolean enable, ConfigContext context) {
        Document doc = context.getDocument();
        List profiles = ConfigSupport.findProfileElements((Document)doc, (Namespace)WildFlyCamelConfigPlugin.NS_DOMAIN);
        for (Element profile : profiles) {
            Element switchyard = profile.getChild("subsystem", NS_SWITCHYARD);
            ConfigSupport.assertExists((Element)switchyard, (String)"Did not find the switchyard subsystem");
            Element modules = switchyard.getChild("modules", NS_SWITCHYARD);
            ConfigSupport.assertExists((Element)modules, (String)"Did not find the <modules> element");
            FuseIntegrationConfigPlugin.updateSwitchyardModule(enable, modules, "org.fuse.integration.switchyard.component.bpm", "org.switchyard.component.bpm.deploy.BPMComponent");
            FuseIntegrationConfigPlugin.updateSwitchyardModule(enable, modules, "org.fuse.integration.switchyard.component.rules", "org.switchyard.component.rules.deploy.RulesComponent");
        }
    }

    private static void updateSwitchyardModule(boolean enable, Element modules, String id, String className) {
        Element module = ConfigSupport.findElementWithAttributeValue((Element)modules, (String)"module", (Namespace)NS_SWITCHYARD, (String)"identifier", (String)id);
        if (enable && module == null) {
            modules.addContent((Content)new Text("    "));
            modules.addContent((Content)new Element("module", NS_SWITCHYARD).setAttribute("identifier", id).setAttribute("implClass", className));
            modules.addContent((Content)new Text("    "));
        }
        if (!enable && module != null) {
            module.getParentElement().removeContent((Content)module);
        }
    }
}

