/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.config.manifest.ContainerManifest;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperation;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperationType;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperations;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeEngine;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManager;
import org.switchyard.component.rules.RulesConstants;
import org.switchyard.component.rules.RulesMessages;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.component.rules.operation.RulesOperationType;

public class RulesExchangeHandler
extends KnowledgeExchangeHandler {
    private static final AtomicInteger FIRE_UNTIL_HALT_COUNT = new AtomicInteger();
    private static final KnowledgeOperation DEFAULT_OPERATION = new KnowledgeOperation((KnowledgeOperationType)RulesOperationType.EXECUTE);
    private KnowledgeRuntimeManager _perRequestRuntimeManager = null;
    private KnowledgeRuntimeManager _singletonRuntimeManager = null;
    private Thread _fireUntilHaltThread = null;

    public RulesExchangeHandler(RulesComponentImplementationModel model, ServiceDomain serviceDomain, QName serviceName) {
        super((KnowledgeComponentImplementationModel)model, serviceDomain, serviceName);
    }

    protected void doStart() {
        super.doStart();
        this._perRequestRuntimeManager = this.newPerRequestRuntimeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        try {
            KieScanner scanner = (KieScanner)this._perRequestRuntimeManager.getRuntimeEngine().getKieSession().getEnvironment().get("KieScanner");
            if (scanner != null) {
                try {
                    scanner.stop();
                    scanner.shutdown();
                }
                catch (Throwable t) {
                    CommonKnowledgeLogger.ROOT_LOGGER.problemStopppingKieScanner(t.getMessage());
                }
                finally {
                    String releaseId = this._model.getManifest().getContainer().getReleaseId();
                    if (releaseId != null && !releaseId.trim().equals("")) {
                        KieServices _kieServices = KieServices.Factory.get();
                        _kieServices.getRepository().removeKieModule(ContainerManifest.toReleaseId((String)releaseId));
                    }
                }
            }
            this._perRequestRuntimeManager.close();
        }
        finally {
            try {
                this.disposeSingletonRuntimeEngine();
            }
            finally {
                super.doStop();
            }
        }
    }

    public KnowledgeOperation getDefaultOperation() {
        return DEFAULT_OPERATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOperation(Exchange exchange, KnowledgeOperation operation) throws HandlerException {
        Message inputMessage = exchange.getMessage();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        HashMap<String, Object> expressionVariables = new HashMap<String, Object>();
        RulesOperationType operationType = (RulesOperationType)operation.getType();
        switch (operationType) {
            case EXECUTE: {
                KnowledgeRuntimeEngine runtime = this.getPerRequestRuntimeEngine();
                KnowledgeOperations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime, (boolean)false);
                try {
                    KieSession session = runtime.getKieSession();
                    if (ExchangePattern.IN_ONLY.equals((Object)exchangePattern)) {
                        List facts = KnowledgeOperations.getInputList((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
                        for (Object fact : facts) {
                            session.insert(fact);
                        }
                        session.fireAllRules();
                        break;
                    }
                    if (!ExchangePattern.IN_OUT.equals((Object)exchangePattern)) break;
                    KieCommands cmds = KieServices.Factory.get().getCommands();
                    ArrayList<Command> batch = new ArrayList<Command>();
                    Map inouts = KnowledgeOperations.getInputOutputMap((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
                    for (Map.Entry inout : inouts.entrySet()) {
                        batch.add(cmds.newInsert(inout.getValue(), (String)inout.getKey()));
                    }
                    List facts = KnowledgeOperations.getInputOnlyList((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
                    batch.add(cmds.newInsertElements((Iterable)facts));
                    batch.add(cmds.newFireAllRules());
                    BatchExecutionCommand exec = cmds.newBatchExecution(batch, "Result");
                    ExecutionResults results = (ExecutionResults)session.execute((Command)exec);
                    for (String id : inouts.keySet()) {
                        expressionVariables.put(id, results.getValue(id));
                    }
                    expressionVariables.putAll(this.getGlobalVariables(runtime));
                    break;
                }
                finally {
                    this.disposePerRequestRuntimeEngine(runtime);
                }
            }
            case INSERT: 
            case FIRE_ALL_RULES: {
                KnowledgeRuntimeEngine runtime = this.getSingletonRuntimeEngine();
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    RulesExchangeHandler rulesExchangeHandler = this;
                    synchronized (rulesExchangeHandler) {
                        this.fireAllRules(inputMessage, operation);
                        expressionVariables.putAll(this.getGlobalVariables(runtime));
                    }
                } else if (KnowledgeOperations.containsGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime)) {
                    RulesExchangeHandler rulesExchangeHandler = this;
                    synchronized (rulesExchangeHandler) {
                        this.fireAllRules(inputMessage, operation);
                    }
                } else {
                    this.fireAllRules(inputMessage, operation);
                }
                if (!this.isDispose(exchange, inputMessage)) break;
                this.disposeSingletonRuntimeEngine();
                break;
            }
            case FIRE_UNTIL_HALT: {
                KnowledgeRuntimeEngine runtime = this.getSingletonRuntimeEngine();
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    RulesExchangeHandler rulesExchangeHandler = this;
                    synchronized (rulesExchangeHandler) {
                        this.fireUntilHalt(inputMessage, exchange, operation);
                        expressionVariables.putAll(this.getGlobalVariables(runtime));
                    }
                } else if (KnowledgeOperations.containsGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime)) {
                    RulesExchangeHandler rulesExchangeHandler = this;
                    synchronized (rulesExchangeHandler) {
                        this.fireUntilHalt(inputMessage, exchange, operation);
                    }
                } else {
                    this.fireUntilHalt(inputMessage, exchange, operation);
                }
                if (!this.isDispose(exchange, inputMessage)) break;
                this.disposeSingletonRuntimeEngine();
                break;
            }
            default: {
                throw RulesMessages.MESSAGES.unsupportedOperationType(operationType.toString());
            }
        }
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            Message outputMessage = exchange.createMessage();
            KnowledgeOperations.setFaults((Message)outputMessage, (KnowledgeOperation)operation, expressionVariables);
            if (outputMessage.getContent() != null) {
                exchange.sendFault(outputMessage);
            } else {
                KnowledgeOperations.setOutputs((Message)outputMessage, (KnowledgeOperation)operation, expressionVariables);
                exchange.send(outputMessage);
            }
        }
    }

    private KnowledgeRuntimeEngine getPerRequestRuntimeEngine() {
        return (KnowledgeRuntimeEngine)this._perRequestRuntimeManager.getRuntimeEngine();
    }

    private void disposePerRequestRuntimeEngine(KnowledgeRuntimeEngine perRequestRuntimeEngine) {
        this._perRequestRuntimeManager.disposeRuntimeEngine((RuntimeEngine)perRequestRuntimeEngine);
    }

    private synchronized KnowledgeRuntimeEngine getSingletonRuntimeEngine() {
        if (this._singletonRuntimeManager == null) {
            this._singletonRuntimeManager = this.newSingletonRuntimeManager();
        }
        return (KnowledgeRuntimeEngine)this._singletonRuntimeManager.getRuntimeEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void disposeSingletonRuntimeEngine() {
        if (this._singletonRuntimeManager != null) {
            try {
                this._singletonRuntimeManager.disposeRuntimeEngine(this._singletonRuntimeManager.getRuntimeEngine());
            }
            finally {
                try {
                    this._singletonRuntimeManager.close();
                }
                finally {
                    this._singletonRuntimeManager = null;
                }
            }
        }
    }

    private boolean isDispose(Exchange exchange, Message message) {
        return this.isBoolean(exchange, message, RulesConstants.DISPOSE_PROPERTY);
    }

    private void fireUntilHalt(Message inputMessage, Exchange exchange, KnowledgeOperation operation) throws HandlerException {
        KnowledgeRuntimeEngine runtime = this.getSingletonRuntimeEngine();
        KnowledgeOperations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime, (boolean)true);
        KieSession session = runtime.getKieSession();
        if (this._fireUntilHaltThread == null && runtime.getWrapped() instanceof Disposable) {
            ClassLoader fireUntilHaltLoader = Classes.getTCCL();
            if (fireUntilHaltLoader == null) {
                fireUntilHaltLoader = this.getLoader();
            }
            FireUntilHalt fireUntilHalt = new FireUntilHalt(this, runtime, fireUntilHaltLoader);
            ((Disposable)runtime.getWrapped()).addDisposeListener((DisposeListener)fireUntilHalt);
            this._fireUntilHaltThread = fireUntilHalt.startThread();
        }
        String undefinedVariable = KnowledgeOperations.toVariable((Object)exchange);
        Map inputMap = KnowledgeOperations.getListMap((Message)inputMessage, (List)operation.getInputExpressionMappings(), (boolean)true, (String)undefinedVariable);
        if (inputMap.size() > 0) {
            for (Map.Entry inputEntry : inputMap.entrySet()) {
                String eventId;
                String key = (String)inputEntry.getKey();
                if (undefinedVariable.equals(key) && (eventId = Strings.trimToNull((String)operation.getEventId())) != null) {
                    key = eventId;
                }
                List facts = (List)inputEntry.getValue();
                if (undefinedVariable.equals(key)) {
                    for (Object fact : facts) {
                        session.insert(fact);
                    }
                    continue;
                }
                EntryPoint entryPoint = session.getEntryPoint(key);
                if (entryPoint != null) {
                    for (Object fact : facts) {
                        entryPoint.insert(fact);
                    }
                    continue;
                }
                throw RulesMessages.MESSAGES.unknownEntryPoint(key);
            }
        } else {
            List facts = KnowledgeOperations.getInputList((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
            for (Object fact : facts) {
                session.insert(fact);
            }
        }
    }

    private int fireAllRules(Message inputMessage, KnowledgeOperation operation) {
        KnowledgeRuntimeEngine runtime = this.getSingletonRuntimeEngine();
        RulesOperationType operationType = (RulesOperationType)operation.getType();
        KnowledgeOperations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime, (boolean)true);
        KieSession session = runtime.getKieSession();
        List facts = KnowledgeOperations.getInputList((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
        for (Object fact : facts) {
            session.insert(fact);
        }
        if (RulesOperationType.FIRE_ALL_RULES.equals((Object)operationType)) {
            return session.fireAllRules();
        }
        return 0;
    }

    private final class FireUntilHalt
    implements Runnable,
    DisposeListener {
        private final RulesExchangeHandler _handler;
        private final KnowledgeRuntimeEngine _runtime;
        private final ClassLoader _loader;

        private FireUntilHalt(RulesExchangeHandler handler, KnowledgeRuntimeEngine runtime, ClassLoader loader) {
            this._handler = handler;
            this._runtime = runtime;
            this._loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader originalLoader = Classes.setTCCL((ClassLoader)this._loader);
            try {
                this._runtime.getKieSession().fireUntilHalt();
            }
            finally {
                try {
                    this._handler.disposeSingletonRuntimeEngine();
                }
                finally {
                    Classes.setTCCL((ClassLoader)originalLoader);
                }
            }
        }

        public void onDispose(RuntimeEngine runtime) {
            this._handler._fireUntilHaltThread = null;
        }

        private Thread startThread() {
            Thread thread = new Thread(this);
            String name = ((Object)((Object)this._handler)).getClass().getSimpleName() + ':' + this.getClass().getSimpleName() + ':' + FIRE_UNTIL_HALT_COUNT.incrementAndGet();
            thread.setName(name);
            thread.setDaemon(true);
            thread.start();
            return thread;
        }
    }
}

