/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.kie.api.runtime.Channel;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.ChannelModel;
import org.switchyard.component.common.knowledge.config.model.ChannelsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceChannel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.deploy.ComponentNames;

public class ChannelBuilder
extends KnowledgeBuilder {
    private Class<? extends Channel> _channelClass;
    private String _channelName;
    private QName _serviceName;
    private String _operationName;
    private String _targetNamespace;

    public ChannelBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, ChannelModel channelModel) {
        super(classLoader, serviceDomain);
        if (channelModel != null) {
            ChannelsModel channelsModel = (ChannelsModel)channelModel.getModelParent();
            KnowledgeComponentImplementationModel implementationModel = (KnowledgeComponentImplementationModel)channelsModel.getModelParent();
            ComponentModel componentModel = implementationModel.getComponent();
            QName componentName = componentModel.getQName();
            this._targetNamespace = componentModel.getTargetNamespace();
            this._channelClass = channelModel.getClazz(this.getClassLoader());
            if (this._channelClass == null) {
                this._channelClass = SwitchYardServiceChannel.class;
            }
            this._channelName = channelModel.getName();
            if (this._channelName == null && SwitchYardServiceChannel.class.isAssignableFrom(this._channelClass)) {
                this._channelName = "service";
            }
            this._serviceName = XMLHelper.createQName((String)channelModel.getReference());
            if (this._serviceName != null && componentName != null) {
                this._serviceName = ComponentNames.qualify((QName)componentName, (QName)ComponentNames.unqualify((QName)this._serviceName));
            }
            this._operationName = channelModel.getOperation();
        }
    }

    public String getChannelName() {
        return this._channelName;
    }

    public Channel build() {
        Channel channel = null;
        if (this._channelClass != null && (channel = (Channel)Construction.construct(this._channelClass)) instanceof SwitchYardServiceChannel) {
            SwitchYardServiceChannel sysc = (SwitchYardServiceChannel)channel;
            sysc.setServiceName(this._serviceName);
            sysc.setOperationName(this._operationName);
            sysc.setInvoker(new SwitchYardServiceInvoker(this.getServiceDomain(), this._targetNamespace));
        }
        return channel;
    }

    public static List<ChannelBuilder> builders(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel) {
        ChannelsModel channelsModel;
        ArrayList<ChannelBuilder> builders = new ArrayList<ChannelBuilder>();
        if (implementationModel != null && (channelsModel = implementationModel.getChannels()) != null) {
            for (ChannelModel channelModel : channelsModel.getChannels()) {
                if (channelModel == null) continue;
                builders.add(new ChannelBuilder(classLoader, serviceDomain, channelModel));
            }
        }
        return builders;
    }
}

