/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManager;
import org.switchyard.deploy.ServiceDomainManager;

public final class KnowledgeRuntimeManagerRegistry {
    private static final Map<QName, Map<QName, KnowledgeRuntimeManager>> REGISTRY = Collections.synchronizedMap(new HashMap());

    public static final synchronized KnowledgeRuntimeManager getRuntimeManager(QName serviceDomainName, QName serviceName) {
        Map<QName, KnowledgeRuntimeManager> reg;
        if (serviceDomainName == null) {
            serviceDomainName = ServiceDomainManager.ROOT_DOMAIN;
        }
        return (reg = REGISTRY.get(serviceDomainName)) != null ? reg.get(serviceName) : null;
    }

    public static final synchronized void putRuntimeManager(QName serviceDomainName, QName serviceName, KnowledgeRuntimeManager runtimeManager) {
        Map<QName, KnowledgeRuntimeManager> reg;
        if (serviceDomainName == null) {
            serviceDomainName = ServiceDomainManager.ROOT_DOMAIN;
        }
        if ((reg = REGISTRY.get(serviceDomainName)) == null) {
            reg = Collections.synchronizedMap(new HashMap());
            REGISTRY.put(serviceDomainName, reg);
        }
        if (runtimeManager == null) {
            reg.remove(serviceName);
        } else {
            reg.put(serviceName, runtimeManager);
        }
    }

    public static final synchronized void removeRuntimeManager(QName serviceDomainName, QName serviceName) {
        KnowledgeRuntimeManagerRegistry.putRuntimeManager(serviceDomainName, serviceName, null);
    }

    private KnowledgeRuntimeManagerRegistry() {
    }
}

