/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.eap.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

final class Support {
    Support() {
    }

    static String getJavaFile() throws IOException {
        File file;
        String home = System.getProperty("java.home");
        if (home != null && (file = new File(home, "bin/java")).exists() && file.canExecute()) {
            return file.getCanonicalPath();
        }
        return "java";
    }

    static void pump(InputStream distro, OutputStream fos) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = distro.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
    }

    static Thread startPump(final InputStream is, final OutputStream os) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    Support.pump(is, os);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    static long computeCRC32(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        try (FileInputStream is = new FileInputStream(file);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                crc32.update(buffer, 0, len);
            }
        }
        return crc32.getValue();
    }

    static Process exec(String[] args, File dir) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(args, new String[0], dir);
        Support.startPump(process.getInputStream(), System.out);
        Support.startPump(process.getErrorStream(), System.err);
        return process;
    }
}

