/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.BPMConstants;
import org.switchyard.component.bpm.BPMMessages;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.operation.BPMOperationType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.expression.ExpressionMapping;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperation;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperationType;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperations;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeEngine;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManager;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerRegistry;
import org.switchyard.component.common.knowledge.transaction.TransactionHelper;

public class BPMExchangeHandler
extends KnowledgeExchangeHandler {
    private static final KnowledgeOperation DEFAULT_OPERATION = new KnowledgeOperation((KnowledgeOperationType)BPMOperationType.START_PROCESS);
    private final boolean _persistent;
    private final String _processId;
    private final CorrelationKeyFactory _correlationKeyFactory;
    private KnowledgeRuntimeManager _runtimeManager;

    public BPMExchangeHandler(BPMComponentImplementationModel model, ServiceDomain serviceDomain, QName serviceName) {
        super((KnowledgeComponentImplementationModel)model, serviceDomain, serviceName);
        this._persistent = model.isPersistent();
        this._processId = model.getProcessId();
        this._correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    }

    protected void doStart() {
        super.doStart();
        this._runtimeManager = this.newSingletonRuntimeManager();
        KnowledgeRuntimeManagerRegistry.putRuntimeManager((QName)this.getServiceDomain().getName(), (QName)this.getServiceName(), (KnowledgeRuntimeManager)this._runtimeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        KnowledgeRuntimeManagerRegistry.removeRuntimeManager((QName)this.getServiceDomain().getName(), (QName)this.getServiceName());
        try {
            this._runtimeManager.close();
        }
        finally {
            this._runtimeManager = null;
            super.doStop();
        }
    }

    public KnowledgeOperation getDefaultOperation() {
        return DEFAULT_OPERATION;
    }

    public void handleOperation(Exchange exchange, KnowledgeOperation operation) throws HandlerException {
        Long processInstanceId = null;
        Message inputMessage = exchange.getMessage();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        HashMap<String, Object> expressionVariables = new HashMap<String, Object>();
        TransactionHelper txh = new TransactionHelper(this._persistent);
        BPMOperationType operationType = (BPMOperationType)operation.getType();
        switch (operationType) {
            case START_PROCESS: {
                KnowledgeRuntimeEngine runtime;
                try {
                    txh.begin();
                    runtime = this.getRuntimeEngine();
                    KnowledgeOperations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime, (boolean)true);
                    Map inputMap = KnowledgeOperations.getInputMap((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
                    CorrelationKey correlationKey = this.getCorrelationKey(exchange, inputMessage);
                    ProcessInstance processInstance = correlationKey != null ? ((CorrelationAwareProcessRuntime)runtime.getKieSession()).startProcess(this._processId, correlationKey, inputMap) : runtime.getKieSession().startProcess(this._processId, inputMap);
                    processInstanceId = processInstance.getId();
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        expressionVariables.putAll(this.getGlobalVariables(runtime));
                        expressionVariables.putAll(this.getProcessInstanceVariables(processInstance));
                    }
                    if (!this._persistent) {
                        this._runtimeManager.disposeRuntimeEngine((RuntimeEngine)runtime);
                    }
                    txh.commit();
                    break;
                }
                catch (RuntimeException re) {
                    txh.rollback();
                    throw re;
                }
            }
            case SIGNAL_EVENT: 
            case SIGNAL_EVENT_ALL: {
                KnowledgeRuntimeEngine runtime;
                try {
                    txh.begin();
                    runtime = BPMOperationType.SIGNAL_EVENT.equals((Object)operationType) ? this.getRuntimeEngine(exchange, inputMessage) : this.getRuntimeEngine();
                    KnowledgeOperations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime, (boolean)true);
                    Object eventObject = KnowledgeOperations.getInput((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeRuntimeEngine)runtime);
                    String eventId = operation.getEventId();
                    if (BPMOperationType.SIGNAL_EVENT.equals((Object)operationType)) {
                        processInstanceId = this.getProcessInstanceId(exchange, inputMessage, runtime);
                        if (processInstanceId == null) {
                            throw BPMMessages.MESSAGES.cannotSignalEventUnknownProcessInstanceIdOrUnknownunmatchedCorrelationKey();
                        }
                        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                            ProcessInstance processInstance = runtime.getKieSession().getProcessInstance(processInstanceId.longValue());
                            processInstance.signalEvent(eventId, eventObject);
                            expressionVariables.putAll(this.getGlobalVariables(runtime));
                            expressionVariables.putAll(this.getProcessInstanceVariables(processInstance));
                        } else {
                            runtime.getKieSession().signalEvent(eventId, eventObject, processInstanceId.longValue());
                        }
                    } else {
                        runtime.getKieSession().signalEvent(eventId, eventObject);
                        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                            expressionVariables.putAll(this.getGlobalVariables(runtime));
                        }
                    }
                    if (!this._persistent) {
                        this._runtimeManager.disposeRuntimeEngine((RuntimeEngine)runtime);
                    }
                    txh.commit();
                    break;
                }
                catch (RuntimeException re) {
                    txh.rollback();
                    throw re;
                }
            }
            case ABORT_PROCESS_INSTANCE: {
                KnowledgeRuntimeEngine runtime;
                try {
                    txh.begin();
                    runtime = this.getRuntimeEngine(exchange, inputMessage);
                    processInstanceId = this.getProcessInstanceId(exchange, inputMessage, runtime);
                    if (processInstanceId == null) {
                        throw BPMMessages.MESSAGES.cannotAbortProcessInstance();
                    }
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        expressionVariables.putAll(this.getGlobalVariables(runtime));
                        ProcessInstance processInstance = runtime.getKieSession().getProcessInstance(processInstanceId.longValue());
                        expressionVariables.putAll(this.getProcessInstanceVariables(processInstance));
                    }
                    runtime.getKieSession().abortProcessInstance(processInstanceId.longValue());
                    if (!this._persistent) {
                        this._runtimeManager.disposeRuntimeEngine((RuntimeEngine)runtime);
                    }
                    txh.commit();
                    break;
                }
                catch (RuntimeException re) {
                    txh.rollback();
                    throw re;
                }
            }
            default: {
                throw BPMMessages.MESSAGES.unsupportedOperationType(operationType);
            }
        }
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            Message outputMessage = exchange.createMessage();
            Context outputContext = exchange.getContext(outputMessage);
            if (processInstanceId != null) {
                outputContext.setProperty(BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY, (Object)processInstanceId);
            }
            this.addFaultToExpressionVariables(expressionVariables, operation.getFaultExpressionMappings());
            KnowledgeOperations.setFaults((Message)outputMessage, (KnowledgeOperation)operation, expressionVariables);
            if (outputMessage.getContent() != null) {
                exchange.sendFault(outputMessage);
            } else {
                KnowledgeOperations.setOutputs((Message)outputMessage, (KnowledgeOperation)operation, expressionVariables);
                exchange.send(outputMessage);
            }
        }
    }

    private KnowledgeRuntimeEngine getRuntimeEngine() {
        return (KnowledgeRuntimeEngine)this._runtimeManager.getRuntimeEngine();
    }

    private void addFaultToExpressionVariables(Map<String, Object> expressionVars, List<ExpressionMapping> faultExpressions) {
        if (faultExpressions != null && !faultExpressions.isEmpty()) {
            for (ExpressionMapping expression : faultExpressions) {
                expressionVars.put(expression.getFrom(), null);
            }
        }
    }

    private KnowledgeRuntimeEngine getRuntimeEngine(Exchange exchange, Message message) throws HandlerException {
        CorrelationKey correlationKey;
        RuntimeEngine runtimeEngine = null;
        Long processInstanceId = this.getProcessInstanceId(exchange, message);
        if (processInstanceId != null) {
            runtimeEngine = this._runtimeManager.getRuntimeEngine(processInstanceId);
        }
        if (runtimeEngine == null && (correlationKey = this.getCorrelationKey(exchange, message)) != null) {
            runtimeEngine = this._runtimeManager.getRuntimeEngine(correlationKey);
        }
        if (runtimeEngine == null) {
            throw new HandlerException("runtimeEngine == null");
        }
        return (KnowledgeRuntimeEngine)runtimeEngine;
    }

    private CorrelationKey getCorrelationKey(Exchange exchange, Message message) {
        List properties;
        String ckp = this.getString(exchange, message, BPMConstants.CORRELATION_KEY_PROPERTY);
        if (ckp != null && (properties = Strings.splitTrimToNull((String)ckp, (String)" \t\n\r\f")).size() > 0) {
            return this._correlationKeyFactory.newCorrelationKey(properties);
        }
        return null;
    }

    private Long getProcessInstanceId(Exchange exchange, Message message) {
        return this.getLong(exchange, message, BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY);
    }

    private Long getProcessInstanceId(Exchange exchange, Message message, KnowledgeRuntimeEngine session) {
        CorrelationKey correlationKey;
        Long processInstanceId = this.getProcessInstanceId(exchange, message);
        if (processInstanceId == null && (correlationKey = this.getCorrelationKey(exchange, message)) != null) {
            processInstanceId = this.getProcessInstanceId(correlationKey, session);
        }
        return processInstanceId;
    }

    private Long getProcessInstanceId(CorrelationKey correlationKey, KnowledgeRuntimeEngine session) {
        ProcessInstance processInstance;
        if (correlationKey != null && (processInstance = ((CorrelationAwareProcessRuntime)session.getKieSession()).getProcessInstance(correlationKey)) != null) {
            return processInstance.getId();
        }
        return null;
    }

    private Map<String, Object> getProcessInstanceVariables(ProcessInstance processInstance) {
        Map var;
        HashMap<String, Object> processInstanceVariables = new HashMap<String, Object>();
        if (processInstance instanceof WorkflowProcessInstanceImpl && (var = ((WorkflowProcessInstanceImpl)processInstance).getVariables()) != null) {
            processInstanceVariables.putAll(var);
        }
        return processInstanceVariables;
    }
}

