/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.switchyard.common.io.resource.ResourceDetail;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.config.model.resource.ResourcesModel;

public class ResourceBuilder
extends KnowledgeBuilder {
    private final KieResources _kieResources = KieServices.Factory.get().getResources();
    private URL _url;
    private ResourceType _resourceType;
    private ResourceConfiguration _resourceConfiguration;

    public ResourceBuilder(ClassLoader classLoader, ResourceModel resourceModel) {
        super(classLoader);
        if (resourceModel != null) {
            this._url = resourceModel.getLocationURL(this.getClassLoader());
            this._resourceType = this.convertResourceType(resourceModel.getType());
            ResourceDetail syResourceDetail = resourceModel.getDetail();
            if (syResourceDetail != null && ResourceType.DTABLE.equals((Object)this._resourceType)) {
                String inputType = syResourceDetail.getInputType().toLowerCase().endsWith("csv") ? this.getInputType(syResourceDetail, DecisionTableInputType.CSV.toString()) : this.getInputType(syResourceDetail, DecisionTableInputType.XLS.toString());
                DecisionTableConfiguration dtc = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                dtc.setInputType(DecisionTableInputType.valueOf((String)inputType));
                dtc.setWorksheetName(this.getWorksheetName(syResourceDetail));
                this._resourceConfiguration = dtc;
            }
        }
    }

    public Resource build() {
        Resource resource = null;
        if (this._url != null && (resource = this._kieResources.newUrlResource(this._url)) != null) {
            if (this._resourceType != null) {
                resource.setResourceType(this._resourceType);
            }
            if (this._resourceConfiguration != null) {
                resource.setConfiguration(this._resourceConfiguration);
            }
        }
        return resource;
    }

    private String getInputType(ResourceDetail syResourceDetail, String defaultInputType) {
        String inputType = Strings.trimToNull((String)syResourceDetail.getInputType());
        inputType = inputType != null ? inputType.toUpperCase() : defaultInputType;
        return inputType;
    }

    private String getWorksheetName(ResourceDetail syResourceDetail) {
        String worksheetName = syResourceDetail.getWorksheetName();
        if (worksheetName == null) {
            worksheetName = "";
        }
        return worksheetName;
    }

    private ResourceType convertResourceType(org.switchyard.common.io.resource.ResourceType syResourceType) {
        if (syResourceType != null) {
            String resourceTypeName = syResourceType.getName();
            if ("BPMN".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.BPMN2.getName();
            } else if ("XLS".equals(resourceTypeName) || "CSV".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.DTABLE.getName();
            }
            return ResourceType.getResourceType((String)resourceTypeName);
        }
        return null;
    }

    public static List<ResourceBuilder> builders(ClassLoader classLoader, KnowledgeComponentImplementationModel implementationModel) {
        ManifestModel manifestModel;
        ArrayList<ResourceBuilder> builders = new ArrayList<ResourceBuilder>();
        if (implementationModel != null && (manifestModel = implementationModel.getManifest()) != null) {
            ResourcesModel resourcesModel = manifestModel.getResources();
            builders.addAll(ResourceBuilder.builders(classLoader, resourcesModel));
        }
        return builders;
    }

    public static List<ResourceBuilder> builders(ClassLoader classLoader, ResourcesModel resourcesModel) {
        ArrayList<ResourceBuilder> builders = new ArrayList<ResourceBuilder>();
        if (resourcesModel != null) {
            for (ResourceModel resourceModel : resourcesModel.getResources()) {
                builders.add(new ResourceBuilder(classLoader, resourceModel));
            }
        }
        return builders;
    }
}

