/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.client.ws.KieRemoteWsAuthenticator;
import org.kie.remote.services.ws.command.generated.CommandWebService;
import org.kie.remote.services.ws.command.generated.Execute;
import org.kie.remote.services.ws.command.generated.ExecuteResponse;
import org.kie.services.client.api.RemoteWebserviceClientBuilderImpl;

class RemoteCommandWebserviceClientBuilderImpl
extends RemoteWebserviceClientBuilderImpl<CommandWebService> {
    private static final String commandServiceNamespace = "http://services.remote.kie.org/6.2.0.1/command";
    private static final QName commandServiceQName = new QName("http://services.remote.kie.org/6.2.0.1/command", "CommandServiceBasicAuth");

    RemoteCommandWebserviceClientBuilderImpl() {
    }

    @Override
    public CommandWebService buildBasicAuthClient() {
        JAXBDataBinding jaxbDataBinding;
        URL wsdlUrl;
        this.checkAndFinalizeConfig();
        KieRemoteWsAuthenticator auth = new KieRemoteWsAuthenticator();
        auth.setUserAndPassword(this.config.getUserName(), this.config.getPassword());
        String wsdlLocationSuffix = "ws/CommandService?wsdl";
        try {
            wsdlUrl = new URL(this.config.getServerBaseUrl(), wsdlLocationSuffix);
        }
        catch (MalformedURLException murle) {
            throw new IllegalStateException("Checked URL is not correct: [" + this.config.getServerBaseUrl().toExternalForm() + wsdlLocationSuffix + "]", murle);
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(CommandWebService.class);
        factory.setWsdlURL(wsdlUrl.toExternalForm());
        factory.setServiceName(commandServiceQName);
        HashSet allClasses = new HashSet();
        allClasses.add(JaxbCommandsRequest.class);
        allClasses.add(JaxbCommandsResponse.class);
        allClasses.add(Execute.class);
        allClasses.add(ExecuteResponse.class);
        Set<Class<?>> extraClasses = this.config.getExtraJaxbClasses();
        if (extraClasses != null && !extraClasses.isEmpty()) {
            allClasses.addAll(extraClasses);
        }
        try {
            jaxbDataBinding = new JAXBDataBinding(allClasses.toArray(new Class[allClasses.size()]));
        }
        catch (JAXBException jaxbe) {
            throw new RemoteApiException("Unable to initialize JAXB context for webservice client", jaxbe);
        }
        factory.getClientFactoryBean().setDataBinding((DataBinding)jaxbDataBinding);
        String pwd = this.config.getPassword();
        String user = this.config.getUserName();
        factory.setUsername(user);
        factory.setPassword(pwd);
        CommandWebService commandService = (CommandWebService)factory.create();
        Client proxyClient = ClientProxy.getClient((Object)commandService);
        HTTPConduit conduit = (HTTPConduit)proxyClient.getConduit();
        HTTPClientPolicy httpClientPolicy = conduit.getClient();
        httpClientPolicy.setConnectionTimeout(this.config.getTimeout());
        httpClientPolicy.setReceiveTimeout(this.config.getTimeout());
        String depId = this.config.getDeploymentId();
        if (depId != null && !depId.trim().isEmpty()) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(1);
            String[] depIdHeader = new String[]{depId};
            headers.put("Kie-Deployment-Id", Arrays.asList(depIdHeader));
            proxyClient.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
        }
        return commandService;
    }
}

