/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.kie.api.task.UserGroupCallback;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.io.pull.Puller;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.builder.PropertiesBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.UserGroupCallbackModel;
import org.switchyard.component.common.knowledge.task.PropertiesUserGroupCallback;

public class UserGroupCallbackBuilder
extends KnowledgeBuilder {
    private static final String USER_CALLBACK_IMPL = System.getProperty("org.jbpm.ht.callback");
    private static final String DEFAULT_PROPERTIES_LOCATION = System.getProperty("jbpm.user.group.mapping", System.getProperty("jboss.server.config.dir", "target/classes") + "/roles.properties");
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{Properties.class}, new Class[0]};
    private Class<? extends UserGroupCallback> _userGroupCallbackClass;
    private final PropertiesBuilder _propertiesBuilder = new PropertiesBuilder();

    public UserGroupCallbackBuilder(ClassLoader classLoader, UserGroupCallbackModel userGroupCallbackModel) {
        super(classLoader);
        String location = DEFAULT_PROPERTIES_LOCATION;
        if (location.startsWith("classpath:")) {
            location = location.replaceFirst("classpath:", "");
        } else if (location.startsWith("file:")) {
            location = location.replaceFirst("file:", "");
        }
        PropertiesPuller.PropertiesType propertiesType = PropertiesPuller.PropertiesType.PROPERTIES;
        if (location != null && location.endsWith(".xml")) {
            propertiesType = PropertiesPuller.PropertiesType.XML;
        }
        Properties defaultProperties = (Properties)new PropertiesPuller(propertiesType).pullPath(location, this.getClassLoader(), Puller.PathType.values());
        this._propertiesBuilder.setDefaultProperties(defaultProperties);
        if (userGroupCallbackModel != null) {
            this._userGroupCallbackClass = userGroupCallbackModel.getClazz(this.getClassLoader());
            this._propertiesBuilder.setModelProperties(userGroupCallbackModel.getProperties());
        }
    }

    public UserGroupCallback build() {
        Object callback = null;
        Properties properties = this._propertiesBuilder.build();
        if (this._userGroupCallbackClass != null) {
            callback = this.construct(properties);
        }
        if (callback == null && USER_CALLBACK_IMPL != null) {
            try {
                callback = "props".equalsIgnoreCase(USER_CALLBACK_IMPL) ? new JBossUserGroupCallbackImpl(properties) : UserDataServiceProvider.getUserGroupCallback();
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        if (callback == null) {
            callback = new PropertiesUserGroupCallback(properties);
        }
        return callback;
    }

    private UserGroupCallback construct(Properties properties) {
        UserGroupCallback userGroupCallback = null;
        Constructor<? extends UserGroupCallback> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = this._userGroupCallbackClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                userGroupCallback = (UserGroupCallback)Construction.construct(this._userGroupCallbackClass);
            } else if (parameterTypes.length == 1) {
                userGroupCallback = (UserGroupCallback)Construction.construct(this._userGroupCallbackClass, (Class[])parameterTypes, (Object[])new Object[]{properties});
            }
        }
        catch (Throwable t) {
            throw CommonKnowledgeMessages.MESSAGES.couldNotInstantiateUserGroupCallbackClass(this._userGroupCallbackClass.getName());
        }
        return userGroupCallback;
    }

    public static UserGroupCallbackBuilder builder(ClassLoader classLoader, KnowledgeComponentImplementationModel implementationModel) {
        UserGroupCallbackModel userGroupCallbackModel = implementationModel != null ? implementationModel.getUserGroupCallback() : null;
        return new UserGroupCallbackBuilder(classLoader, userGroupCallbackModel);
    }
}

