/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.service;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceRequest;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceResponse;

public class SwitchYardServiceInvoker {
    private final ServiceDomain _serviceDomain;
    private final String _targetNamespace;

    public SwitchYardServiceInvoker(ServiceDomain serviceDomain) {
        this(serviceDomain, null);
    }

    public SwitchYardServiceInvoker(ServiceDomain serviceDomain, String targetNamespace) {
        this._serviceDomain = serviceDomain;
        this._targetNamespace = targetNamespace;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public SwitchYardServiceResponse invoke(SwitchYardServiceRequest request) {
        HashMap<String, Object> contextOut = new HashMap<String, Object>();
        Object contentOut = null;
        Object fault = null;
        try {
            ServiceDomain serviceDomain;
            String tns;
            QName serviceName = request.getServiceName();
            if (serviceName == null) {
                throw CommonKnowledgeMessages.MESSAGES.serviceNameNull();
            }
            if (Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
                serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
            }
            if ((serviceDomain = this.getServiceDomain()) == null) {
                throw CommonKnowledgeMessages.MESSAGES.serviceDomainNull();
            }
            ServiceReference serviceReference = serviceDomain.getServiceReference(serviceName);
            if (serviceReference == null) {
                throw CommonKnowledgeMessages.MESSAGES.serviceReferenceNull(serviceName.toString());
            }
            FaultHandler handler = new FaultHandler();
            String operationName = request.getOperationName();
            Exchange exchangeIn = operationName != null ? serviceReference.createExchange(operationName, (ExchangeHandler)handler) : serviceReference.createExchange((ExchangeHandler)handler);
            Message messageIn = exchangeIn.createMessage();
            Context contextIn = exchangeIn.getContext(messageIn);
            for (Map.Entry<String, Object> entry : request.getContext().entrySet()) {
                contextIn.setProperty(entry.getKey(), entry.getValue());
            }
            Object contentIn = request.getContent();
            if (contentIn != null) {
                messageIn.setContent(contentIn);
            }
            exchangeIn.send(messageIn);
            if (ExchangePattern.IN_OUT.equals((Object)exchangeIn.getContract().getConsumerOperation().getExchangePattern())) {
                Exchange exchangeOut = handler.waitForOut();
                Message messageOut = exchangeOut.getMessage();
                contentOut = messageOut.getContent();
                for (Property property : exchangeOut.getContext(messageOut).getProperties()) {
                    contextOut.put(property.getName(), property.getValue());
                }
            }
            fault = handler.getFault();
        }
        catch (Throwable t) {
            fault = t;
        }
        return new SwitchYardServiceResponse(contentOut, contextOut, fault);
    }

    private static final class FaultHandler
    extends SynchronousInOutHandler {
        private Object _fault;

        private FaultHandler() {
        }

        private Object getFault() {
            return this._fault;
        }

        public void handleFault(Exchange exchange) {
            this._fault = exchange.getMessage().getContent();
            super.handleFault(exchange);
        }
    }
}

