/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.jbpm.process.workitem.camel.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.camel.CamelContextService;
import org.jbpm.process.workitem.camel.request.RequestMapper;
import org.jbpm.process.workitem.camel.request.RequestPayloadMapper;
import org.jbpm.process.workitem.camel.response.ResponseMapper;
import org.jbpm.process.workitem.camel.response.ResponsePayloadMapper;
import org.jbpm.process.workitem.camel.uri.URIMapper;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class CamelHandler
extends AbstractLogOrThrowWorkItemHandler {
    private final ResponseMapper responseMapper;
    private final RequestMapper requestMapper;
    private final URIMapper uriConverter;
    private CamelContext context;

    public CamelHandler(URIMapper converter) {
        this(converter, new RequestPayloadMapper());
    }

    public CamelHandler(URIMapper converter, RequestMapper processorMapper) {
        this(converter, processorMapper, new ResponsePayloadMapper());
    }

    public CamelHandler(URIMapper converter, RequestMapper processorMapper, ResponseMapper responseMapper) {
        this.uriConverter = converter;
        this.requestMapper = processorMapper;
        this.responseMapper = responseMapper;
    }

    public CamelHandler(URIMapper converter, RequestMapper processorMapper, ResponseMapper responseMapper, boolean logException) {
        this(converter, processorMapper, responseMapper);
        this.setLogThrownException(logException);
    }

    public CamelHandler(URIMapper converter, RequestMapper processorMapper, ResponseMapper responseMapper, CamelContext context) {
        this(converter, processorMapper, responseMapper);
        this.context = context;
    }

    private Map<String, Object> send(WorkItem workItem) throws URISyntaxException {
        String s;
        if (this.context == null) {
            this.context = CamelContextService.getInstance();
        }
        ProducerTemplate template = this.context.createProducerTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>(workItem.getParameters());
        params.remove("TaskName");
        Processor processor = this.requestMapper.mapToRequest(params);
        URI uri = this.uriConverter.toURI(params);
        try {
            s = URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s = uri.toString();
        }
        Endpoint endpoint = this.context.getEndpoint(s);
        Exchange exchange = template.send(endpoint, processor);
        return this.responseMapper.mapFromResponse(exchange);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        Map<String, Object> results = null;
        try {
            results = this.send(workItem);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        workItemManager.completeWorkItem(workItem.getId(), results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

