/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.rules.multi;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.rules.multi.Item;
import org.switchyard.quickstarts.rules.multi.OrderDecision;
import org.switchyard.quickstarts.rules.multi.WarehouseService;

@Service(value=WarehouseService.class)
public class WarehouseServiceImpl
implements WarehouseService {
    @Inject
    @Reference
    private OrderDecision orderDecision;
    private static final Logger LOGGER = Logger.getLogger(WarehouseService.class);
    private static final String SUCCESS = "SUCCESS";
    private final ConcurrentMap<Integer, Item> items = new ConcurrentHashMap<Integer, Item>();

    @Override
    public Item getItem(Integer itemId) {
        System.out.println("++++++ getItem " + itemId);
        Item item = (Item)this.items.get(itemId);
        return item;
    }

    @Override
    public String addItem(Item item) throws Exception {
        if (this.getItem(item.getItemId()) != null) {
            throw new RuntimeException("Item " + item.getItemId() + " already exists!");
        }
        this.items.put(item.getItemId(), item);
        this.orderDecision.addObject(item);
        LOGGER.info((Object)("Added item " + item.getItemId() + " with name " + item.getName()));
        return SUCCESS;
    }

    @Override
    public String updateItem(Item item) throws Exception {
        Item item2 = (Item)this.items.get(item.getItemId());
        item2.setName(item.getName());
        LOGGER.info((Object)("Updated item " + item.getItemId() + " with name " + item.getName()));
        return SUCCESS;
    }

    @Override
    public String removeItem(Integer itemId) throws Exception {
        if (this.getItem(itemId) == null) {
            throw new RuntimeException("Item " + itemId + " not found!");
        }
        this.items.remove(itemId);
        LOGGER.info((Object)("Removed item " + itemId));
        return SUCCESS;
    }

    @Override
    public Integer getItemCount() {
        System.out.println("++++++ getItemCount ");
        return this.items.size();
    }
}

