/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.kie.api.runtime.Channel;
import org.kie.camel.component.KieEndpoint;
import org.kie.internal.runtime.KnowledgeRuntime;

public class KieConsumer
extends DefaultConsumer {
    private KieEndpoint ke;
    private KnowledgeRuntime krt;
    private String channelId;

    public KieConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.ke = (KieEndpoint)endpoint;
        this.krt = (KnowledgeRuntime)this.ke.getExecutor();
        this.channelId = this.ke.getChannel();
    }

    protected void doStop() throws Exception {
        this.krt.unregisterChannel(this.channelId);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        KSessionChannel channel = new KSessionChannel();
        this.krt.registerChannel(this.channelId, (Channel)channel);
    }

    class KSessionChannel
    implements Channel {
        KSessionChannel() {
        }

        public void send(Object pojo) {
            Exchange exchange = KieConsumer.this.ke.createExchange(pojo);
            try {
                KieConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                KieConsumer.this.handleException(e);
            }
        }
    }
}

