/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.util.URISupport;

public abstract class URIMapper {
    protected String schema;

    public URIMapper(String schema) {
        this.schema = schema;
    }

    public abstract URI toURI(Map<String, Object> var1) throws URISyntaxException;

    protected URI prepareCamelUri(String path, Map<String, Object> params) throws URISyntaxException {
        return this.prepareCamelUri(this.schema, path, params);
    }

    protected URI prepareCamelUri(String schema, String path, Map<String, Object> params) throws URISyntaxException {
        URI camelUri;
        String url = schema == null ? path : schema + "://" + path;
        try {
            camelUri = new URI(URISupport.normalizeUri((String)url));
        }
        catch (UnsupportedEncodingException e) {
            camelUri = new URI(url);
        }
        if (params.isEmpty()) {
            return camelUri;
        }
        return URISupport.createURIWithQuery((URI)camelUri, (String)URISupport.createQueryString(params));
    }
}

