/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.integration.fuse.quickstarts.jbpm.workitems.camel;

import java.io.File;
import java.util.HashMap;
import java.util.Random;
import org.jboss.integration.fuse.quickstarts.jbpm.workitems.camel.MortgageApplication;
import org.jbpm.process.workitem.camel.CamelHandler;
import org.jbpm.process.workitem.camel.CamelHandlerFactory;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    int APPLICATION_COUNT = 10;
    int MORTGAGE_MIN = 100000;
    int MORTGAGE_MAX = 1000000;
    int INCOME_MIN = 20000;
    int INCOME_MAX = 200000;
    KieSession kieSession;

    public void start(BundleContext bc) throws Exception {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        CamelHandler handler = CamelHandlerFactory.fileHandler();
        KieServices kieServices = KieServices.Factory.get();
        KieContainer kieContainer = kieServices.newKieClasspathContainer(this.getClass().getClassLoader());
        this.kieSession = kieContainer.newKieSession("camel-workitem-ksession");
        this.kieSession.getWorkItemManager().registerWorkItemHandler("CamelFile", (WorkItemHandler)handler);
        Random random = new Random();
        for (int i = 1; i <= 10; ++i) {
            MortgageApplication mortgageApplication = new MortgageApplication();
            mortgageApplication.setId(i);
            mortgageApplication.setIncome(random.nextInt(this.INCOME_MAX - this.INCOME_MIN) + this.INCOME_MIN);
            mortgageApplication.setAmmount(random.nextInt(this.MORTGAGE_MAX - this.MORTGAGE_MIN) + this.MORTGAGE_MIN);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("payloadVar", "");
            params.put("pathVar", tempDir.getAbsolutePath());
            params.put("fileNameVar", "");
            params.put("applicationVar", mortgageApplication);
            this.kieSession.startProcess("camelFileProcess", params);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        this.kieSession.dispose();
    }
}

