/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.builder.RemoteConfigurationBuilder;
import org.switchyard.component.common.knowledge.config.builder.ResourceBuilder;
import org.switchyard.component.common.knowledge.config.manifest.ContainerManifest;
import org.switchyard.component.common.knowledge.config.manifest.Manifest;
import org.switchyard.component.common.knowledge.config.manifest.RemoteManifest;
import org.switchyard.component.common.knowledge.config.manifest.ResourcesManifest;
import org.switchyard.component.common.knowledge.config.model.ContainerModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.component.common.knowledge.config.model.RemoteModel;
import org.switchyard.config.model.resource.ResourcesModel;

public class ManifestBuilder
extends KnowledgeBuilder {
    private final Manifest _manifest;

    public ManifestBuilder(ClassLoader classLoader, ManifestModel manifestModel) {
        super(classLoader);
        Manifest manifest = null;
        if (manifestModel != null) {
            ContainerModel containerModel = manifestModel.getContainer();
            if (containerModel != null) {
                manifest = new ContainerManifest(containerModel.getBaseName(), containerModel.getReleaseId(), containerModel.isScan(), containerModel.getScanInterval(), containerModel.getSessionName());
            } else {
                ResourcesModel resourcesModel = manifestModel.getResources();
                if (resourcesModel != null) {
                    manifest = new ResourcesManifest(ResourceBuilder.builders(this.getClassLoader(), resourcesModel));
                } else {
                    RemoteModel remoteModel = manifestModel.getRemote();
                    if (remoteModel != null) {
                        manifest = new RemoteManifest(new RemoteConfigurationBuilder(this.getClassLoader(), remoteModel));
                    }
                }
            }
        }
        if (manifest == null) {
            manifest = new ContainerManifest();
        }
        this._manifest = manifest;
    }

    public Manifest build() {
        return this._manifest;
    }

    public static ManifestBuilder builder(ClassLoader classLoader, KnowledgeComponentImplementationModel implementationModel) {
        ManifestModel manifestModel = implementationModel != null ? implementationModel.getManifest() : null;
        return new ManifestBuilder(classLoader, manifestModel);
    }
}

