/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.switchyard.component.common.knowledge.config.items.ExtendedRegisterableItemsFactory;

public class CompoundRegisterableItemsFactory
implements ExtendedRegisterableItemsFactory {
    private final InternalRegisterableItemsFactory _rootFactory;
    private final List<RegisterableItemsFactory> _factories;

    public CompoundRegisterableItemsFactory(InternalRegisterableItemsFactory rootFactory, RegisterableItemsFactory ... factories) {
        this(rootFactory, factories != null ? Arrays.asList(factories) : null);
    }

    public CompoundRegisterableItemsFactory(InternalRegisterableItemsFactory rootFactory, Collection<RegisterableItemsFactory> factories) {
        this._rootFactory = rootFactory;
        this._factories = new ArrayList<RegisterableItemsFactory>();
        if (factories != null) {
            for (RegisterableItemsFactory f : factories) {
                if (f == null || f == rootFactory || f == this || this._factories.contains(f)) continue;
                this._factories.add(f);
            }
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> list = new ArrayList<AgendaEventListener>();
        list.addAll(this._rootFactory.getAgendaEventListeners(runtime));
        for (RegisterableItemsFactory f : this._factories) {
            list.addAll(f.getAgendaEventListeners(runtime));
        }
        return list;
    }

    public Map<String, Object> getGlobals(RuntimeEngine runtime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this._rootFactory.getGlobals(runtime));
        for (RegisterableItemsFactory f : this._factories) {
            map.putAll(f.getGlobals(runtime));
        }
        return map;
    }

    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        ArrayList<ProcessEventListener> list = new ArrayList<ProcessEventListener>();
        list.addAll(this._rootFactory.getProcessEventListeners(runtime));
        for (RegisterableItemsFactory f : this._factories) {
            list.addAll(f.getProcessEventListeners(runtime));
        }
        return list;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        ArrayList<RuleRuntimeEventListener> list = new ArrayList<RuleRuntimeEventListener>();
        list.addAll(this._rootFactory.getRuleRuntimeEventListeners(runtime));
        for (RegisterableItemsFactory f : this._factories) {
            list.addAll(f.getRuleRuntimeEventListeners(runtime));
        }
        return list;
    }

    public List<TaskLifeCycleEventListener> getTaskListeners() {
        ArrayList<TaskLifeCycleEventListener> list = new ArrayList<TaskLifeCycleEventListener>();
        list.addAll(this._rootFactory.getTaskListeners());
        for (RegisterableItemsFactory f : this._factories) {
            list.addAll(f.getTaskListeners());
        }
        return list;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> map = new HashMap<String, WorkItemHandler>();
        map.putAll(this._rootFactory.getWorkItemHandlers(runtime));
        for (RegisterableItemsFactory f : this._factories) {
            map.putAll(f.getWorkItemHandlers(runtime));
        }
        return map;
    }

    @Override
    public List<KieBaseEventListener> getKieBaseEventListeners(RuntimeEngine runtime) {
        ArrayList<KieBaseEventListener> list = new ArrayList<KieBaseEventListener>();
        for (RegisterableItemsFactory f : this._factories) {
            if (!(f instanceof ExtendedRegisterableItemsFactory)) continue;
            ExtendedRegisterableItemsFactory e = (ExtendedRegisterableItemsFactory)f;
            list.addAll(e.getKieBaseEventListeners(runtime));
        }
        return list;
    }

    public InternalRuntimeManager getRuntimeManager() {
        return this._rootFactory.getRuntimeManager();
    }

    public void setRuntimeManager(InternalRuntimeManager manager) {
        this._rootFactory.setRuntimeManager(manager);
    }
}

