/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime;

import java.util.HashMap;
import java.util.Map;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.runtime.manager.impl.PerRequestRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.task.api.InternalTaskService;

public class KnowledgePerRequestRuntimeManager
extends PerRequestRuntimeManager {
    private static Map<String, ThreadLocal<RuntimeEngine>> local = new HashMap<String, ThreadLocal<RuntimeEngine>>();

    public KnowledgePerRequestRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, factory, taskServiceFactory, identifier);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        RuntimeEngineImpl runtime = null;
        if (local.get(this.getIdentifier()) != null) {
            return local.get(this.getIdentifier()).get();
        }
        if (this.engineInitEager) {
            InternalTaskService internalTaskService = (InternalTaskService)this.getTaskServiceFactory().newTaskService();
            runtime = new RuntimeEngineImpl(this.getFactory().newKieSession(), (TaskService)internalTaskService);
            runtime.setManager((RuntimeManager)this);
            this.configureRuntimeOnTaskService(internalTaskService, (RuntimeEngine)runtime);
            this.registerDisposeCallback((RuntimeEngine)runtime, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)this, (RuntimeEngine)runtime));
            this.registerDisposeCallback((RuntimeEngine)runtime, (TransactionSynchronization)new DestroySessionTransactionSynchronization(runtime.getKieSession()));
            this.registerItems((RuntimeEngine)runtime);
            this.attachManager((RuntimeEngine)runtime);
        } else {
            runtime = new RuntimeEngineImpl(context, (RuntimeEngineInitlializer)new PerRequestInitializer());
            runtime.setManager((RuntimeManager)this);
        }
        ThreadLocal<RuntimeEngineImpl> loc = new ThreadLocal<RuntimeEngineImpl>();
        loc.set(runtime);
        local.put(this.getIdentifier(), loc);
        return runtime;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        RuntimeEngine runtimeInUse = local.get(this.getIdentifier()).get();
        if (runtimeInUse == null || runtimeInUse.getKieSession().getIdentifier() != ksession.getIdentifier()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        block6: {
            if (this.isClosed()) {
                throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
            }
            local.remove(this.getIdentifier());
            try {
                if (this.canDestroy(runtime)) {
                    runtime.getKieSession().destroy();
                } else if (runtime instanceof Disposable) {
                    ((Disposable)runtime).dispose();
                }
            }
            catch (Exception e) {
                if (!(runtime instanceof Disposable)) break block6;
                ((Disposable)runtime).dispose();
            }
        }
    }

    private class PerRequestInitializer
    implements RuntimeEngineInitlializer {
        private PerRequestInitializer() {
        }

        public KieSession initKieSession(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            RuntimeEngine inUse = (RuntimeEngine)((ThreadLocal)local.get(KnowledgePerRequestRuntimeManager.this.getIdentifier())).get();
            if (inUse != null && ((RuntimeEngineImpl)inUse).internalGetKieSession() != null) {
                return inUse.getKieSession();
            }
            KieSession ksession = KnowledgePerRequestRuntimeManager.this.getFactory().newKieSession();
            ((RuntimeEngineImpl)engine).internalSetKieSession(ksession);
            KnowledgePerRequestRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine));
            KnowledgePerRequestRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DestroySessionTransactionSynchronization(ksession));
            KnowledgePerRequestRuntimeManager.this.registerItems(engine);
            KnowledgePerRequestRuntimeManager.this.attachManager(engine);
            return ksession;
        }

        public TaskService initTaskService(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            InternalTaskService internalTaskService = (InternalTaskService)KnowledgePerRequestRuntimeManager.this.getTaskServiceFactory().newTaskService();
            KnowledgePerRequestRuntimeManager.this.configureRuntimeOnTaskService(internalTaskService, engine);
            return internalTaskService;
        }
    }
}

