/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jbpm.process.audit.AuditLogService;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.client.api.command.RemoteRuntimeEngine;
import org.switchyard.component.common.knowledge.transaction.TransactionInvocationHandler;

public class KnowledgeRuntimeEngine
implements RuntimeEngine {
    private final RuntimeEngine _wrapped;
    private final boolean _persistent;

    public KnowledgeRuntimeEngine(RuntimeEngine wrapped, boolean persistent) {
        this._wrapped = wrapped;
        this._persistent = persistent;
    }

    public RuntimeEngine getWrapped() {
        return this._wrapped;
    }

    public boolean isRemote() {
        return this._wrapped instanceof RemoteRuntimeEngine;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public KieSession getKieSession() {
        return this._wrapped.getKieSession();
    }

    public TaskService getTaskService() {
        TransactionInvocationHandler ih = new TransactionInvocationHandler(this._wrapped.getTaskService(), this._persistent);
        return (TaskService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{InternalTaskService.class, EventService.class}, (InvocationHandler)ih);
    }

    public AuditService getAuditService() {
        TransactionInvocationHandler ih = new TransactionInvocationHandler(this._wrapped.getAuditService(), this._persistent);
        return (AuditService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{AuditLogService.class}, (InvocationHandler)ih);
    }

    public Long getSessionIdentifier() {
        return this.getKieSession().getIdentifier();
    }

    public Globals getSessionGlobals() {
        return this.isRemote() ? null : this.getKieSession().getGlobals();
    }
}

