/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FaceletCacheImpl
extends FaceletCache<DefaultFacelet> {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    private Map<String, DefaultFacelet> _facelets;
    private Map<String, DefaultFacelet> _viewMetadataFacelets;
    private long _refreshPeriod;

    FaceletCacheImpl(long refreshPeriod) {
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        this._facelets = new HashMap<String, DefaultFacelet>();
        this._viewMetadataFacelets = new HashMap<String, DefaultFacelet>();
    }

    @Override
    public DefaultFacelet getFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)this.getMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._facelets);
                newLoc.put(key, f);
                this._facelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isFaceletCached(URL url) {
        return this._facelets.containsKey(url);
    }

    @Override
    public DefaultFacelet getViewMetadataFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._viewMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)this.getMetadataMemberFactory().newInstance(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._viewMetadataFacelets);
                newLoc.put(key, f);
                this._viewMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    @Override
    public boolean isViewMetadataFaceletCached(URL url) {
        return this._viewMetadataFacelets.containsKey(url);
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                URLConnection conn = facelet.getSource().openConnection();
                long lastModified = ResourceLoaderUtils.getResourceLastModified(conn);
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
            }
        }
        return false;
    }
}

