/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.karaf.provider;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.provider.DefaultSecurityProvider;

public class KarafSecurityProvider
extends DefaultSecurityProvider {
    public void populate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        super.populate(serviceSecurity, securityContext);
    }

    public void clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        super.clear(serviceSecurity, securityContext);
    }

    public boolean checkRolesAllowed(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        Set rolesAllowed = serviceSecurity.getRolesAllowed();
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        for (String roleName : rolesAllowed) {
            boolean isInRole = this.isCallerInRole(securityContext, roleName, securityDomain);
            if (!isInRole) continue;
            return true;
        }
        return false;
    }

    public boolean isCallerInRole(SecurityContext securityContext, String roleName, String securityDomain) {
        Subject subject = securityContext.getSubject(securityDomain, false);
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof GroupPrincipal) || !principal.getName().equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        new ProxyLoginModule();
    }
}

