/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.serial.CompressionType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.WrapperSerializer;

public final class GZIPSerializer
extends WrapperSerializer {
    public GZIPSerializer(Serializer serializer) {
        super(serializer, CompressionType.GZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream(out);
        GZIPOutputStream gzip = new GZIPOutputStream(out, this.getBufferSize());
        try {
            this.getWrapped().serialize(obj, type, gzip);
            gzip.finish();
            gzip.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                gzip.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        in = new GZIPInputStream(in, this.getBufferSize());
        try {
            T t = this.getWrapped().deserialize(in, type);
            return t;
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
    }
}

