/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceRegistration;
import org.switchyard.deploy.osgi.SwitchYardEvent;
import org.switchyard.deploy.osgi.SwitchYardListener;

@Command(scope="switchyard", name="deployment-list", description="List switchyard deployments.")
public class DeploymentList
extends OsgiCommandSupport {
    private static final String ID_COLUMN_LABEL = "Id";
    private static final String NAME_COLUMN_LABEL = "Name";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final String DEFAULT_FIELD_PREAMBLE = "[ ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ]";
    private static final String DEFAULT_HEADER_PREAMBLE = "  ";
    private static final String DEFAULT_HEADER_POSTAMBLE = "  ";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final int MAX_COLUMN_WIDTH = Integer.MAX_VALUE;
    private final List<SwitchYardEvent> _events = new CopyOnWriteArrayList<SwitchYardEvent>();

    protected Object doExecute() throws Exception {
        SwitchYardListener listener = new SwitchYardListener(){

            public void switchyardEvent(SwitchYardEvent event) {
                DeploymentList.this._events.add(event);
            }
        };
        ServiceRegistration reg = this.getBundleContext().registerService(SwitchYardListener.class, (Object)listener, null);
        reg.unregister();
        if (!this._events.isEmpty()) {
            Map<String, Integer> columnWidths = DeploymentList.computeColumnWidths(this._events);
            String headerFormat = DeploymentList.buildFormatString(columnWidths, true);
            String rowFormat = DeploymentList.buildFormatString(columnWidths, false);
            PrintStream out = System.out;
            out.println(String.format(headerFormat, ID_COLUMN_LABEL, NAME_COLUMN_LABEL, STATUS_COLUMN_LABEL));
            for (SwitchYardEvent event : this._events) {
                out.println(String.format(rowFormat, DeploymentList.getId(event), DeploymentList.getName(event), DeploymentList.getStatus(event)));
            }
        }
        return null;
    }

    private static Map<String, Integer> computeColumnWidths(Iterable<SwitchYardEvent> events) throws Exception {
        if (events == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<SwitchyardEvent>");
        }
        int maxIdLen = 0;
        int maxNameLen = 0;
        int maxStatusLen = 0;
        for (SwitchYardEvent event : events) {
            maxIdLen = Math.max(maxIdLen, DeploymentList.getId(event).length());
            maxNameLen = Math.max(maxNameLen, DeploymentList.getName(event).length());
            maxStatusLen = Math.max(maxStatusLen, DeploymentList.getStatus(event).length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(ID_COLUMN_LABEL, maxIdLen);
        retval.put(NAME_COLUMN_LABEL, maxNameLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        return retval;
    }

    private static String getId(SwitchYardEvent event) {
        return Long.toString(event.getBundle().getBundleId());
    }

    private static String getName(SwitchYardEvent event) {
        return event.getBundle().getSymbolicName();
    }

    private static String getStatus(SwitchYardEvent event) {
        switch (event.getType()) {
            case 1: {
                return "Creating";
            }
            case 6: {
                return "Grace Period";
            }
            case 2: {
                return "Created";
            }
            case 3: {
                return "Destroying";
            }
            case 4: {
                return "Destroyed";
            }
            case 5: {
                return "Failure";
            }
        }
        return "Unknown";
    }

    private static String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = "  ";
            fieldPostamble = "  ";
        } else {
            fieldPreamble = DEFAULT_FIELD_PREAMBLE;
            fieldPostamble = DEFAULT_FIELD_POSTAMBLE;
        }
        int columnWidthIncrement = 0;
        int idLen = Math.min(columnWidths.get(ID_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(idLen).append('.').append(idLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }
}

