/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.builder.ReleaseId;

public class DependencyDescriptor {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private ArtifactVersion artifactVersion;
    private long artifactTimestamp = 0L;

    public DependencyDescriptor(Dependency dependency) {
        this(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getVersion());
    }

    public DependencyDescriptor(Artifact artifact) {
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.isSnapshot() ? artifact.getBaseVersion() : artifact.getVersion(), artifact.getExtension(), artifact.getVersion());
        if (artifact.getFile() != null) {
            this.artifactTimestamp = artifact.getFile().lastModified();
        }
    }

    public DependencyDescriptor(ReleaseId releaseId) {
        this(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion(), "jar", releaseId.getVersion());
    }

    public DependencyDescriptor(ReleaseId releaseId, long artifactTimestamp) {
        this(releaseId);
        this.artifactTimestamp = artifactTimestamp;
    }

    public DependencyDescriptor(String groupId, String artifactId, String version, String type, String currentVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.setArtifactVersion(currentVersion);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public ReleaseId getReleaseIdWithoutVersion() {
        return new ReleaseIdImpl(this.groupId, this.artifactId, "0");
    }

    public ReleaseId getReleaseId() {
        return new ReleaseIdImpl(this.groupId, this.artifactId, this.version);
    }

    public ReleaseId getArtifactReleaseId() {
        return new ReleaseIdImpl(this.groupId, this.artifactId, this.artifactVersion.toString());
    }

    public String getType() {
        return this.type;
    }

    public boolean isFixedVersion() {
        return DependencyDescriptor.isFixedVersion(this.version);
    }

    public static boolean isFixedVersion(String version) {
        return !DependencyDescriptor.isSnapshot(version) && !DependencyDescriptor.isRangedVersion(version) && !version.equals("LATEST") && !version.equals("RELEASE");
    }

    public static boolean isRangedVersion(String version) {
        return version.indexOf(40) >= 0 || version.indexOf(41) >= 0 || version.indexOf(91) >= 0 || version.indexOf(93) >= 0;
    }

    public boolean isSameArtifact(ReleaseId releaseId) {
        return this.groupId.equals(releaseId.getGroupId()) && this.artifactId.equals(releaseId.getArtifactId());
    }

    public boolean isSnapshot() {
        return DependencyDescriptor.isSnapshot(this.version);
    }

    public static boolean isSnapshot(String version) {
        return version.endsWith("SNAPSHOT");
    }

    public boolean isValid() {
        return this.version != null;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toResolvableString() {
        return this.isSnapshot() ? this.toString() : this.groupId + ":" + this.artifactId + ":LATEST";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyDescriptor that = (DependencyDescriptor)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public void setArtifactVersion(String version) {
        this.artifactVersion = new DefaultArtifactVersion(version);
    }

    public boolean isNewerThan(DependencyDescriptor o) {
        int comparison = this.artifactVersion.compareTo(o.artifactVersion);
        return comparison > 0 || comparison == 0 && this.artifactTimestamp > o.artifactTimestamp;
    }
}

