/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.command.CommandService;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.jbpm.runtime.manager.impl.mapper.EnvironmentAwareProcessInstanceContext;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerProcessInstanceRuntimeManager
extends AbstractRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(PerProcessInstanceRuntimeManager.class);
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<Object, RuntimeEngine>> local = new ThreadLocal();
    private Mapper mapper;

    public PerProcessInstanceRuntimeManager(org.kie.api.runtime.manager.RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.mapper = ((RuntimeEnvironment)environment).getMapper();
        this.registry.register((RuntimeManager)this);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        RuntimeEngineImpl runtime = null;
        Object contextId = context.getContextId();
        if (!(context instanceof ProcessInstanceIdContext)) {
            logger.warn("ProcessInstanceIdContext shall be used when interacting with PerProcessInstance runtime manager");
        }
        if (this.engineInitEager) {
            KieSession ksession = null;
            Long ksessionId = null;
            if (contextId == null || context instanceof EmptyContext) {
                ksession = this.factory.newKieSession();
                ksessionId = ksession.getIdentifier();
            } else {
                RuntimeEngine localRuntime = this.findLocalRuntime(contextId);
                if (localRuntime != null) {
                    return localRuntime;
                }
                ksessionId = this.mapper.findMapping(context, this.identifier);
                if (ksessionId == null) {
                    throw new SessionNotFoundException("No session found for context " + context.getContextId());
                }
                ksession = this.factory.findKieSessionById(ksessionId);
            }
            InternalTaskService internalTaskService = (InternalTaskService)this.taskServiceFactory.newTaskService();
            runtime = new RuntimeEngineImpl(ksession, (TaskService)internalTaskService);
            runtime.setManager((RuntimeManager)this);
            this.configureRuntimeOnTaskService(internalTaskService, runtime);
            this.registerDisposeCallback(runtime, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)this, runtime));
            this.registerItems(runtime);
            this.attachManager(runtime);
            ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, runtime, this.identifier));
        } else {
            RuntimeEngine localRuntime = this.findLocalRuntime(contextId);
            if (localRuntime != null) {
                return localRuntime;
            }
            runtime = new RuntimeEngineImpl(context, new PerProcessInstanceInitializer());
            runtime.setManager((RuntimeManager)this);
        }
        this.saveLocalRuntime(contextId, runtime);
        return runtime;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (context == null || context.getContextId() == null) {
            return;
        }
        Long ksessionId = this.mapper.findMapping(context, this.identifier);
        if (ksessionId == null) {
            Object contextId = this.mapper.findContextId(Long.valueOf(ksession.getIdentifier()), this.identifier);
            if (contextId != null) {
                throw new IllegalStateException("KieSession with id " + ksession.getIdentifier() + " is already used by another context");
            }
            return;
        }
        if (ksession.getIdentifier() != ksessionId.longValue()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.removeLocalRuntime(runtime);
        if (runtime instanceof Disposable) {
            if (this.mapper instanceof InMemoryMapper && ((InMemoryMapper)this.mapper).hasContext(runtime.getKieSession().getIdentifier())) {
                return;
            }
            ((Disposable)runtime).dispose();
        }
    }

    @Override
    public void close() {
        try {
            if (!(this.taskServiceFactory instanceof LocalTaskServiceFactory)) {
                this.removeRuntimeFromTaskService((InternalTaskService)this.taskServiceFactory.newTaskService());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.factory.close();
    }

    public boolean validate(Long ksessionId, Long processInstanceId) {
        Long mapped = this.mapper.findMapping((Context)ProcessInstanceIdContext.get((Long)processInstanceId), this.identifier);
        return mapped == ksessionId;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected RuntimeEngine findLocalRuntime(Object processInstanceId) {
        if (processInstanceId == null) {
            return null;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            return null;
        }
        return map.get(processInstanceId);
    }

    protected void saveLocalRuntime(Object processInstanceId, RuntimeEngine runtime) {
        if (processInstanceId == null || !(processInstanceId instanceof Long)) {
            return;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            map = new HashMap<Object, RuntimeEngine>();
            local.set(map);
        }
        map.put(processInstanceId, runtime);
    }

    protected void removeLocalRuntime(RuntimeEngine runtime) {
        Map<Object, RuntimeEngine> map = local.get();
        Object keyToRemove = -1L;
        if (map != null) {
            for (Map.Entry<Object, RuntimeEngine> entry : map.entrySet()) {
                if (!runtime.equals(entry.getValue())) continue;
                keyToRemove = entry.getKey();
                break;
            }
            map.remove(keyToRemove);
        }
    }

    @Override
    public void init() {
        KieSession initialKsession = this.factory.newKieSession();
        initialKsession.execute((Command)new DestroyKSessionCommand(initialKsession, this));
        if (!"false".equalsIgnoreCase(System.getProperty("org.jbpm.rm.init.timer")) && this.mapper instanceof JPAMapper) {
            List<Long> ksessionsToInit = ((JPAMapper)this.mapper).findKSessionToInit(this.identifier);
            for (Long id : ksessionsToInit) {
                initialKsession = this.factory.findKieSessionById(id);
                initialKsession.execute((Command)new DisposeKSessionCommand(initialKsession, this));
            }
        }
    }

    private class PerProcessInstanceInitializer
    implements RuntimeEngineInitlializer {
        private PerProcessInstanceInitializer() {
        }

        @Override
        public KieSession initKieSession(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            Long found;
            Object contextId = context.getContextId();
            if (contextId != null && !(context instanceof EmptyContext) && (found = PerProcessInstanceRuntimeManager.this.mapper.findMapping(context, manager.getIdentifier())) == null) {
                PerProcessInstanceRuntimeManager.this.removeLocalRuntime(engine);
                throw new SessionNotFoundException("No session found for context " + context.getContextId());
            }
            KieSession ksession = null;
            Long ksessionId = null;
            if (contextId == null || context instanceof EmptyContext) {
                ksession = PerProcessInstanceRuntimeManager.this.factory.newKieSession();
                ksessionId = ksession.getIdentifier();
            } else {
                RuntimeEngine localRuntime = ((PerProcessInstanceRuntimeManager)manager).findLocalRuntime(contextId);
                if (localRuntime != null && ((RuntimeEngineImpl)engine).internalGetKieSession() != null) {
                    return localRuntime.getKieSession();
                }
                ksessionId = PerProcessInstanceRuntimeManager.this.mapper.findMapping(context, manager.getIdentifier());
                if (ksessionId == null) {
                    throw new SessionNotFoundException("No session found for context " + context.getContextId());
                }
                ksession = PerProcessInstanceRuntimeManager.this.factory.findKieSessionById(ksessionId);
            }
            ((RuntimeEngineImpl)engine).internalSetKieSession(ksession);
            PerProcessInstanceRuntimeManager.this.registerItems(engine);
            PerProcessInstanceRuntimeManager.this.attachManager(engine);
            PerProcessInstanceRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine));
            ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, engine, manager.getIdentifier()));
            return ksession;
        }

        @Override
        public TaskService initTaskService(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            InternalTaskService internalTaskService = (InternalTaskService)PerProcessInstanceRuntimeManager.this.taskServiceFactory.newTaskService();
            PerProcessInstanceRuntimeManager.this.configureRuntimeOnTaskService(internalTaskService, engine);
            return internalTaskService;
        }
    }

    private static class DisposeKSessionCommand
    implements GenericCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DisposeKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.internal.command.Context context) {
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                this.initialKsession.dispose();
                return null;
            }
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PPIRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int arg0) {
                        DisposeKSessionCommand.this.initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.dispose();
            }
            return null;
        }
    }

    private static class DestroyKSessionCommand
    implements GenericCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DestroyKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.internal.command.Context context) {
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                if (this.initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                    CommandService commandService = ((CommandBasedStatefulKnowledgeSession)this.initialKsession).getCommandService();
                    ((SingleSessionCommandService)commandService).destroy();
                } else {
                    ((KnowledgeCommandContext)context).getKieSession().destroy();
                }
                return null;
            }
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PPIRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                        if (DestroyKSessionCommand.this.initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                            CommandService commandService = ((CommandBasedStatefulKnowledgeSession)DestroyKSessionCommand.this.initialKsession).getCommandService();
                            ((SingleSessionCommandService)commandService).destroy();
                        }
                    }

                    public void afterCompletion(int arg0) {
                        DestroyKSessionCommand.this.initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.destroy();
            }
            return null;
        }
    }

    private class MaintainMappingListener
    extends DefaultProcessEventListener {
        private Long ksessionId;
        private RuntimeEngine runtime;
        private String managerId;

        MaintainMappingListener(Long ksessionId, RuntimeEngine runtime, String managerId) {
            this.ksessionId = ksessionId;
            this.runtime = runtime;
            this.managerId = managerId;
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.removeMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.managerId);
            PerProcessInstanceRuntimeManager.this.removeLocalRuntime(this.runtime);
            PerProcessInstanceRuntimeManager.this.registerDisposeCallback(this.runtime, (TransactionSynchronization)new DestroySessionTransactionSynchronization(this.runtime.getKieSession()));
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.saveMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.ksessionId, this.managerId);
            PerProcessInstanceRuntimeManager.this.saveLocalRuntime(event.getProcessInstance().getId(), this.runtime);
        }
    }
}

