/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDescriptor;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static Logger log = LoggerFactory.getLogger(ComponentRegistry.class);
    private Map<Bean<?>, ComponentDescriptor<?>> descriptors = new HashMap();
    private BundleContext bundleContext;
    private Set<InjectionPoint> nonComponentDependencies = new HashSet<InjectionPoint>();

    public ComponentRegistry(int dummy) {
    }

    public <S> void addComponent(Bean<S> component) {
        this.descriptors.put(component, new ComponentDescriptor<S>(component));
    }

    public <S> void addDependency(Bean<S> component, InjectionPoint ip) {
        log.debug("adding dependency {} -> {}", component, (Object)ip);
        ComponentDescriptor<?> descriptor = this.descriptors.get(component);
        descriptor.addDependency(ip);
    }

    public Set<Bean<?>> getComponents() {
        return this.descriptors.keySet();
    }

    public ComponentDescriptor<?> getDescriptor(Bean<?> component) {
        return this.descriptors.get(component);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void addNonComponentDependency(InjectionPoint ip) {
        this.nonComponentDependencies.add(ip);
    }

    public Set<InjectionPoint> getNonComponentDependencies() {
        return this.nonComponentDependencies;
    }

    public boolean isComponent(Bean<?> bean) {
        return this.descriptors.containsKey(bean);
    }
}

