/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQJMSConnectionFactory;
import org.kie.remote.client.api.RemoteClientBuilder;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteWebserviceClientBuilder;
import org.kie.remote.client.api.exception.InsufficientInfoToBuildException;
import org.kie.remote.services.ws.command.generated.CommandWebService;
import org.kie.services.client.api.RemoteCommandWebserviceClientBuilderImpl;
import org.kie.services.client.api.RemoteJmsRuntimeEngineBuilderImpl;
import org.kie.services.client.api.RemoteRestRuntimeEngineBuilderImpl;
import org.kie.services.client.api.command.RemoteConfiguration;

public abstract class RemoteRuntimeEngineFactory
extends org.kie.remote.client.api.RemoteRuntimeEngineFactory {
    protected RemoteConfiguration config;

    public static RemoteJmsRuntimeEngineBuilder newJmsBuilder() {
        return new RemoteJmsRuntimeEngineBuilderImpl();
    }

    public static RemoteRestRuntimeEngineBuilder newRestBuilder() {
        return new RemoteRestRuntimeEngineBuilderImpl();
    }

    public static RemoteWebserviceClientBuilder<RemoteWebserviceClientBuilder, CommandWebService> newCommandWebServiceClientBuilder() {
        return new RemoteCommandWebserviceClientBuilderImpl();
    }

    static void checkAndFinalizeConfig(RemoteConfiguration config, RemoteClientBuilder builder) {
        if (builder instanceof RemoteJmsRuntimeEngineBuilderImpl) {
            RemoteJmsRuntimeEngineBuilderImpl jmsBuilder = (RemoteJmsRuntimeEngineBuilderImpl)builder;
            if (config.getUserName() == null) {
                throw new InsufficientInfoToBuildException("A user name is required to access the JMS queues!");
            }
            if (config.getPassword() == null) {
                throw new InsufficientInfoToBuildException("A password is required to access the JMS queues!");
            }
            if (jmsBuilder.createOwnFactory) {
                HashMap<String, Object> connParams;
                HornetQJMSConnectionFactory createdConnectionFactory = null;
                if (jmsBuilder.hostName == null) {
                    throw new InsufficientInfoToBuildException("A host name or IP address is required to create a JMS ConnectionFactory!");
                }
                if (jmsBuilder.jmsConnectorPort == null) {
                    throw new InsufficientInfoToBuildException("A connector port is required to create a JMS ConnectionFactory!");
                }
                if (config.getUseUssl()) {
                    connParams = new HashMap<String, Object>(7);
                    connParams.put("port", jmsBuilder.jmsConnectorPort);
                    connParams.put("host", jmsBuilder.hostName);
                    jmsBuilder.checkKeyAndTruststoreInfo();
                    connParams.put("ssl-enabled", true);
                    connParams.put("key-store-password", jmsBuilder.keystorePassword);
                    connParams.put("key-store-path", jmsBuilder.keystoreLocation);
                    connParams.put("trust-store-password", jmsBuilder.truststorePassword);
                    connParams.put("trust-store-path", jmsBuilder.truststoreLocation);
                } else {
                    connParams = new HashMap(3);
                    connParams.put("port", jmsBuilder.jmsConnectorPort);
                    connParams.put("host", jmsBuilder.hostName);
                    connParams.put("ssl-enabled", false);
                }
                createdConnectionFactory = new HornetQJMSConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connParams)});
                config.setConnectionFactory((ConnectionFactory)createdConnectionFactory);
            }
            if (jmsBuilder.jbossServerHostName != null && jmsBuilder.remoteInitialContext == null) {
                jmsBuilder.remoteInitialContext = RemoteRuntimeEngineFactory.getRemoteJbossInitialContext(jmsBuilder.jbossServerHostName, config.getUserName(), config.getPassword());
            }
            if (jmsBuilder.remoteInitialContext != null) {
                config.setRemoteInitialContext(jmsBuilder.remoteInitialContext);
            } else {
                config.checkValidJmsValues();
            }
        } else if (builder instanceof RemoteRestRuntimeEngineBuilder) {
            if (config.getServerBaseUrl() == null) {
                throw new InsufficientInfoToBuildException("A URL is required to access the REST services.");
            }
            if (config.getUserName() == null) {
                throw new InsufficientInfoToBuildException("A user name is required to access the REST services.");
            }
            if (config.getPassword() == null) {
                throw new InsufficientInfoToBuildException("A password is required to access the REST services.");
            }
        } else if (builder instanceof RemoteWebserviceClientBuilder) {
            if (config.getServerBaseUrl() == null) {
                throw new InsufficientInfoToBuildException("A URL is required to access the web services.");
            }
            if (config.getUserName() == null) {
                throw new InsufficientInfoToBuildException("A user name is required to access the web services.");
            }
            if (config.getPassword() == null) {
                throw new InsufficientInfoToBuildException("A password is required to access the web services.");
            }
        }
        if (config.getExtraJaxbClasses() != null && !config.getExtraJaxbClasses().isEmpty() && config.getDeploymentId() == null) {
            throw new InsufficientInfoToBuildException("A deployment id is required if user-defined class instances are being sent.");
        }
    }
}

