/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.logging.Logger;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Scannable;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.ValidationResult;
import org.switchyard.validate.config.model.FileEntryModel;
import org.switchyard.validate.config.model.XmlSchemaType;
import org.switchyard.validate.config.model.XmlValidateModel;
import org.switchyard.validate.internal.ValidateLogger;
import org.switchyard.validate.internal.ValidateMessages;
import org.switchyard.validate.xml.internal.XmlValidatorDTDResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@Scannable(value=false)
public class XmlValidator
extends BaseValidator<Message> {
    private static final Logger LOGGER = Logger.getLogger(XmlValidator.class);
    private XmlSchemaType _schemaType;
    private String _schemaTypeUri;
    private boolean _failOnWarning;
    private boolean _isNamespaceAware;
    private List<FileEntryModel> _schemaConfig;
    private List<FileEntryModel> _catalogConfig;
    private SAXParserFactory _parserFactory;
    private XmlValidatorCatalogResolver _catalogResolver;
    private XmlValidatorDTDResolver _dtdResolver;
    private List<String> _schemaFileNames = new ArrayList<String>();
    private List<String> _catalogFileNames = new ArrayList<String>();

    public XmlValidator(QName name, XmlValidateModel model) {
        super(name);
        this._schemaType = model.getSchemaType();
        if (this._schemaType == null) {
            throw ValidateMessages.MESSAGES.couldNotInstantiateXmlValidator();
        }
        switch (this._schemaType) {
            case DTD: {
                this._schemaTypeUri = "http://www.w3.org/TR/REC-xml";
                break;
            }
            case XML_SCHEMA: {
                this._schemaTypeUri = "http://www.w3.org/2001/XMLSchema";
                break;
            }
            case RELAX_NG: {
                this._schemaTypeUri = "http://relaxng.org/ns/structure/1.0";
                break;
            }
            default: {
                StringBuilder builder = new StringBuilder();
                for (XmlSchemaType s : XmlSchemaType.values()) {
                    builder.append(s.name() + ", ");
                }
                if (builder.length() >= 2) {
                    builder.delete(builder.length() - 2, builder.length());
                }
                throw ValidateMessages.MESSAGES.couldNotInstantiateXmlValidatorBadSchemaType(this._schemaType.toString(), builder.toString());
            }
        }
        this._failOnWarning = model.failOnWarning();
        this._isNamespaceAware = model.namespaceAware();
        if (model.getSchemaFiles() != null) {
            this._schemaConfig = model.getSchemaFiles().getEntries();
        }
        if (model.getSchemaCatalogs() != null) {
            this._catalogConfig = model.getSchemaCatalogs().getEntries();
        }
        this.setup();
    }

    protected void setup() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)new StringBuffer("Setting up XmlValidator:[").append(this.formatUnparsedConfigs()).append("]"));
        }
        this._parserFactory = SAXParserFactory.newInstance();
        this._parserFactory.setXIncludeAware(true);
        this._parserFactory.setNamespaceAware(this._isNamespaceAware);
        if (this._catalogConfig != null) {
            ArrayList<URL> foundCatalogs = new ArrayList<URL>();
            for (FileEntryModel entry : this._catalogConfig) {
                URL located = this.locateFile(entry.getFile());
                if (located != null) {
                    foundCatalogs.add(located);
                    continue;
                }
                ValidateLogger.ROOT_LOGGER.schemaCatalogNotLocated(entry.getFile());
            }
            if (foundCatalogs.size() > 0) {
                CatalogManager manager = new CatalogManager();
                manager.setIgnoreMissingProperties(true);
                manager.setAllowOasisXMLCatalogPI(true);
                manager.setPreferPublic(true);
                manager.setRelativeCatalogs(false);
                manager.setUseStaticCatalog(false);
                manager.setVerbosity(0);
                this._catalogResolver = new XmlValidatorCatalogResolver(manager);
                this._catalogResolver.namespaceAware = this._isNamespaceAware;
                this._catalogFileNames = new ArrayList<String>();
                for (URL catalog : foundCatalogs) {
                    try {
                        this._catalogResolver.getCatalog().parseCatalog(catalog);
                        this._catalogFileNames.add(catalog.toString());
                    }
                    catch (Exception e) {
                        ValidateLogger.ROOT_LOGGER.schemaCatalogNotParsed(catalog.toString(), e.getMessage());
                    }
                }
            }
        }
        if ("http://www.w3.org/TR/REC-xml".equals(this._schemaTypeUri)) {
            this._parserFactory.setValidating(true);
            if (this._schemaConfig != null) {
                for (FileEntryModel entry : this._schemaConfig) {
                    if (entry.getFile() == null) continue;
                    this._schemaFileNames.add(entry.getFile());
                }
            }
            this._dtdResolver = new XmlValidatorDTDResolver(this._schemaFileNames);
        } else {
            if (this._schemaConfig == null) {
                throw ValidateMessages.MESSAGES.schemaFileMustBeSpecified(this._schemaType.toString());
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance(this._schemaTypeUri);
            if (this._catalogResolver != null) {
                schemaFactory.setResourceResolver(this._catalogResolver);
            }
            ArrayList<StreamSource> foundSchemas = new ArrayList<StreamSource>();
            for (FileEntryModel entry : this._schemaConfig) {
                URL located = this.locateFile(entry.getFile());
                if (located != null) {
                    this._schemaFileNames.add(located.toString());
                    foundSchemas.add(new StreamSource(located.toExternalForm()));
                    continue;
                }
                ValidateLogger.ROOT_LOGGER.schemaFileNotLocated(entry.getFile());
            }
            this._dtdResolver = new XmlValidatorDTDResolver(this._schemaFileNames);
            if (foundSchemas.size() == 0) {
                throw ValidateMessages.MESSAGES.noValidSchemaFileFound();
            }
            try {
                Schema schema = schemaFactory.newSchema(foundSchemas.toArray(new Source[0]));
                this._parserFactory.setSchema(schema);
            }
            catch (SAXException e) {
                throw new SwitchYardException((Throwable)e);
            }
        }
    }

    public ValidationResult validate(Message msg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)new StringBuffer("Entering XML validation:[").append(this.formatUnparsedConfigs()).append(" / ").append(this.formatParsedConfigs()).append("]"));
        }
        try {
            XMLReader validatingParser = this.createValidatingParser();
            XmlValidationErrorHandler errorHandler = new XmlValidationErrorHandler(this._failOnWarning);
            validatingParser.setErrorHandler(errorHandler);
            String input = (String)msg.getContent(String.class);
            if (this._schemaFileNames != null && this._schemaFileNames.size() > 0) {
                validatingParser.setEntityResolver(this._dtdResolver);
            }
            if (InputStream.class.isAssignableFrom(msg.getContent().getClass())) {
                msg.setContent((Object)new ByteArrayInputStream(input.getBytes()));
            } else if (Reader.class.isAssignableFrom(msg.getContent().getClass())) {
                msg.setContent((Object)new StringReader(input));
            }
            validatingParser.parse(new InputSource(new StringReader(input)));
            if (errorHandler.validationFailed()) {
                return XmlValidator.invalidResult((String)this.formatErrorMessage(errorHandler.getErrors()).toString());
            }
        }
        catch (SAXException e) {
            throw new SwitchYardException((Throwable)e);
        }
        catch (ParserConfigurationException pce) {
            throw new SwitchYardException((Throwable)pce);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
        return XmlValidator.validResult();
    }

    protected XMLReader createValidatingParser() throws SAXException, ParserConfigurationException {
        XMLReader validatingParser = this._parserFactory.newSAXParser().getXMLReader();
        if ("http://www.w3.org/TR/REC-xml".equals(this._schemaTypeUri) && this._catalogResolver != null) {
            validatingParser.setEntityResolver((EntityResolver)((Object)this._catalogResolver));
        }
        return validatingParser;
    }

    protected URL locateFile(String path) {
        if (path == null) {
            return null;
        }
        if (new File(path).exists()) {
            try {
                return new File(path).toURI().toURL();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            URL res = Classes.getResource((String)path);
            if (res != null) {
                return res;
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
        return null;
    }

    protected StringBuffer formatErrorMessage(List<Exception> errors) {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer().append(errors.size()).append(" validation error(s): ").append(nl);
        for (Exception e : errors) {
            buf.append(this.formatRootCause(e)).append(nl);
        }
        return buf;
    }

    protected StringBuffer formatRootCause(Throwable t) {
        Throwable cause = t;
        StringBuffer buf = new StringBuffer(cause.getClass().getName()).append(": ").append(cause.getMessage());
        while ((cause = cause.getCause()) != null) {
            buf.append(" --- Caused by ").append(cause.getClass().getName()).append(": ").append(cause.getMessage());
        }
        return buf;
    }

    protected StringBuffer formatUnparsedConfigs() {
        StringBuffer buf = new StringBuffer();
        buf.append("schema type=").append((Object)this._schemaType);
        if (this._schemaConfig != null && this._schemaConfig.size() > 0) {
            buf.append(", schema files=").append(this._schemaConfig.toString());
        }
        if (this._catalogConfig != null && this._catalogConfig.size() > 0) {
            buf.append(", catalogs=").append(this._catalogConfig.toString());
        }
        return buf;
    }

    protected StringBuffer formatParsedConfigs() {
        StringBuffer buf = new StringBuffer();
        buf.append("schema type=").append((Object)this._schemaType);
        if (this._schemaFileNames.size() > 0) {
            buf.append(", schema files=").append(this._schemaFileNames.toString());
        }
        if (this._catalogFileNames.size() > 0) {
            buf.append(", catalogs=").append(this._catalogFileNames.toString());
        }
        return buf;
    }

    private final class XmlValidatorLSInput
    implements LSInput {
        private Reader _characterStream;
        private InputStream _byteStream;
        private InputSource _inputSource;
        private String _publicId;
        private String _systemId;
        private String _baseURI;
        private String _encoding;
        private boolean _certifiedText;

        private XmlValidatorLSInput(InputSource xsd, String publicId, String systemId, String baseURI) {
            this._inputSource = xsd;
            this.setPublicId(publicId);
            this.setSystemId(systemId);
            this.setBaseURI(baseURI);
            this.setEncoding("UTF-8");
            this.setCertifiedText(false);
        }

        @Override
        public Reader getCharacterStream() {
            if (this._inputSource != null) {
                return this._inputSource.getCharacterStream();
            }
            return this._characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this._characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            if (this._inputSource != null) {
                return this._inputSource.getByteStream();
            }
            return this._byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this._byteStream = byteStream;
        }

        @Override
        public String getStringData() {
            if (this._inputSource == null) {
                return null;
            }
            Reader r = this._inputSource.getCharacterStream();
            StringBuilder buf = new StringBuilder();
            try {
                int c;
                while ((c = r.read()) != -1) {
                    buf.append((char)c);
                }
            }
            catch (Exception e) {
                return null;
            }
            return buf.toString();
        }

        @Override
        public void setStringData(String stringData) {
            this._inputSource = new InputSource(new StringReader(stringData));
        }

        @Override
        public String getSystemId() {
            return this._systemId;
        }

        @Override
        public String getPublicId() {
            return this._publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this._publicId = publicId;
        }

        @Override
        public void setSystemId(String systemId) {
            this._systemId = systemId;
        }

        @Override
        public String getBaseURI() {
            return this._baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this._baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this._encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        @Override
        public boolean getCertifiedText() {
            return this._certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this._certifiedText = certifiedText;
        }
    }

    private class XmlValidatorCatalogResolver
    extends CatalogResolver
    implements LSResourceResolver {
        public XmlValidatorCatalogResolver(CatalogManager manager) {
            super(manager);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String userDir;
            String resolved = this.getResolvedEntity(publicId, systemId);
            URL fileUrl = null;
            File testFile = null;
            if (resolved != null) {
                try {
                    fileUrl = new URL(resolved);
                    testFile = new File(fileUrl.getPath());
                }
                catch (MalformedURLException mue) {
                    ValidateLogger.ROOT_LOGGER.malformedURLDuringResolution(resolved);
                }
            }
            if ((fileUrl == null || !testFile.exists()) && systemId.contains(userDir = System.getProperty("user.dir"))) {
                File systemFile = new File(systemId);
                String systemFileName = systemFile.getName();
                fileUrl = XmlValidator.this.locateFile(systemFileName);
            }
            if (fileUrl != null) {
                try {
                    return new InputSource(fileUrl.openStream());
                }
                catch (IOException ioe) {
                    ValidateLogger.ROOT_LOGGER.openStreamIssue(fileUrl.toString());
                }
            }
            return null;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return new XmlValidatorLSInput(this.resolveEntity(publicId, systemId), publicId, systemId, baseURI);
        }
    }

    protected class XmlValidationErrorHandler
    extends DefaultHandler {
        private boolean _validationFailed;
        private boolean _failOnWarning;
        private List<Exception> _errors = new ArrayList<Exception>();

        public XmlValidationErrorHandler(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
            this._validationFailed = false;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this._validationFailed = true;
            this._errors.add(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this._validationFailed = true;
            this._errors.add(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this._failOnWarning) {
                this._validationFailed = true;
                this._errors.add(e);
            } else {
                StringBuffer warning = new StringBuffer();
                warning.append(XmlValidator.this.formatParsedConfigs()).append(": ").append(e.getMessage());
                ValidateLogger.ROOT_LOGGER.warningDuringValidation(warning.toString());
            }
        }

        public boolean validationFailed() {
            return this._validationFailed;
        }

        public List<Exception> getErrors() {
            return Collections.unmodifiableList(this._errors);
        }
    }
}

