/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.config.builder.ChannelBuilder;
import org.switchyard.component.common.knowledge.config.builder.LoggerBuilder;
import org.switchyard.component.common.knowledge.config.items.ExtendedRegisterableItemsFactory;
import org.switchyard.component.common.knowledge.config.manifest.ContainerManifest;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeEngine;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerType;

public class KnowledgeRuntimeManager
implements RuntimeManager {
    private final KieServices _kieServices;
    private final ClassLoader _classLoader;
    private final KnowledgeRuntimeManagerType _type;
    private final QName _serviceDomainName;
    private final QName _serviceName;
    private final RuntimeManager _runtimeManager;
    private final List<ChannelBuilder> _channelBuilders;
    private final List<LoggerBuilder> _loggerBuilders;
    private final boolean _persistent;
    private final Set<Long> _sessionIds = Collections.synchronizedSet(new LinkedHashSet());

    KnowledgeRuntimeManager(ClassLoader classLoader, KnowledgeRuntimeManagerType type, QName serviceDomainName, QName serviceName, RuntimeManager runtimeManager, boolean persistent, List<ChannelBuilder> channelBuilders, List<LoggerBuilder> loggerBuilders) {
        this._kieServices = KieServices.Factory.get();
        this._classLoader = classLoader;
        this._type = type;
        this._serviceDomainName = serviceDomainName;
        this._serviceName = serviceName;
        this._runtimeManager = runtimeManager;
        this._persistent = persistent;
        this._channelBuilders = channelBuilders;
        this._loggerBuilders = loggerBuilders;
    }

    public KnowledgeRuntimeManagerType getType() {
        return this._type;
    }

    public QName getServiceDomainName() {
        return this._serviceDomainName;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public String getIdentifier() {
        return this._runtimeManager.getIdentifier();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public RuntimeEngine getRuntimeEngine() {
        return this.getRuntimeEngine((Context)null);
    }

    public RuntimeEngine getRuntimeEngine(Long processInstanceId) {
        return this.getRuntimeEngine((Context<?>)ProcessInstanceIdContext.get((Long)processInstanceId));
    }

    public RuntimeEngine getRuntimeEngine(CorrelationKey correlationKey) {
        return this.getRuntimeEngine((Context<?>)CorrelationKeyContext.get((CorrelationKey)correlationKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        KnowledgeRuntimeEngine runtimeEngine;
        if (context == null || this._type != KnowledgeRuntimeManagerType.PER_PROCESS_INSTANCE) {
            context = EmptyContext.get();
        }
        ClassLoader origTCCL = Classes.setTCCL((ClassLoader)this._classLoader);
        try {
            RuntimeEngine wrapped = this._runtimeManager.getRuntimeEngine(context);
            this.initRuntimeEngine(wrapped);
            runtimeEngine = new KnowledgeRuntimeEngine(wrapped, this._persistent);
        }
        finally {
            Classes.setTCCL((ClassLoader)origTCCL);
        }
        return runtimeEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRuntimeEngine(RuntimeEngine runtimeEngine) {
        if (runtimeEngine instanceof Disposable) {
            Disposable disposable = (Disposable)runtimeEngine;
            final KieSession session = runtimeEngine.getKieSession();
            if (session != null) {
                final Long sessionId = session.getIdentifier();
                Set<Long> set = this._sessionIds;
                synchronized (set) {
                    if (!this._sessionIds.contains(sessionId)) {
                        this._sessionIds.add(sessionId);
                        disposable.addDisposeListener(new DisposeListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onDispose(RuntimeEngine runtime) {
                                Set set = KnowledgeRuntimeManager.this._sessionIds;
                                synchronized (set) {
                                    KnowledgeRuntimeManager.this._sessionIds.remove(sessionId);
                                }
                            }
                        });
                        Environment environment = session.getEnvironment();
                        ExtendedRegisterableItemsFactory extendedRIF = ExtendedRegisterableItemsFactory.Env.removeFromEnvironment(environment);
                        if (extendedRIF != null) {
                            List<KieBaseEventListener> baseListeners = extendedRIF.getKieBaseEventListeners(runtimeEngine);
                            for (KieBaseEventListener baseListener : baseListeners) {
                                session.getKieBase().addEventListener(baseListener);
                            }
                        }
                        for (ChannelBuilder channelBuilder : this._channelBuilders) {
                            final String name = channelBuilder.getChannelName();
                            Channel channel = channelBuilder.build();
                            if (name == null || channel == null) continue;
                            session.registerChannel(name, channel);
                            disposable.addDisposeListener(new DisposeListener(){

                                public void onDispose(RuntimeEngine runtime) {
                                    session.unregisterChannel(name);
                                }
                            });
                        }
                        for (LoggerBuilder loggerBuilder : this._loggerBuilders) {
                            final KieRuntimeLogger logger2 = loggerBuilder.build((KieRuntimeEventManager)session);
                            disposable.addDisposeListener(new DisposeListener(){

                                public void onDispose(RuntimeEngine runtime) {
                                    try {
                                        logger2.close();
                                    }
                                    catch (Throwable t) {
                                        CommonKnowledgeLogger.ROOT_LOGGER.problemClosingKieRuntimeLogger(t.getMessage());
                                    }
                                }
                            });
                        }
                        ContainerManifest containerManifest = ContainerManifest.removeFromEnvironment(environment);
                        if (containerManifest != null && containerManifest.isScan()) {
                            KieContainer kieContainer = containerManifest.getKieContainer();
                            final ReleaseId releaseId = containerManifest.getReleaseId();
                            if (releaseId != null) {
                                final KieScanner scanner = this._kieServices.newKieScanner(kieContainer);
                                disposable.addDisposeListener(new DisposeListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void onDispose(RuntimeEngine runtime) {
                                        try {
                                            scanner.stop();
                                            scanner.shutdown();
                                        }
                                        catch (Throwable t) {
                                            CommonKnowledgeLogger.ROOT_LOGGER.problemStopppingKieScanner(t.getMessage());
                                        }
                                        finally {
                                            if (releaseId != null) {
                                                KnowledgeRuntimeManager.this._kieServices.getRepository().removeKieModule(releaseId);
                                            }
                                        }
                                    }
                                });
                                scanner.start(containerManifest.getScanInterval().longValue());
                            }
                        }
                    }
                }
            }
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        if (runtime instanceof KnowledgeRuntimeEngine) {
            runtime = ((KnowledgeRuntimeEngine)runtime).getWrapped();
        }
        this._runtimeManager.disposeRuntimeEngine(runtime);
    }

    public void close() {
        this._runtimeManager.close();
    }
}

