/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.apache.aries.jpa.container.context.impl.ManagedPersistenceContextFactory;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceContextManager
extends ServiceTracker {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private static final Filter filter;
    private final Map<String, Set<Bundle>> persistenceContextConsumers = new HashMap<String, Set<Bundle>>();
    private final Map<String, HashMap<String, Object>> persistenceContextDefinitions = new HashMap<String, HashMap<String, Object>>();
    private final Map<String, ServiceReference> persistenceUnits = new HashMap<String, ServiceReference>();
    private final Map<String, ServiceRegistration> entityManagerRegistrations = new HashMap<String, ServiceRegistration>();
    private final JTAPersistenceContextRegistry persistenceContextRegistry;

    public PersistenceContextManager(BundleContext ctx, JTAPersistenceContextRegistry registry) {
        super(ctx, filter, null);
        this.persistenceContextRegistry = registry;
    }

    public void close() {
        super.close();
        for (ServiceRegistration reg : this.entityManagerRegistrations.values()) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        boolean register;
        String unitName;
        if (_logger.isDebugEnabled()) {
            _logger.debug("A new managed persistence unit, {}, has been detected.", new Object[]{reference});
        }
        if ((unitName = (String)reference.getProperty("osgi.unit.name")) == null) {
            unitName = "";
        }
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            if (this.persistenceUnits.containsKey(unitName)) {
                _logger.warn(NLS.MESSAGES.getMessage("pu.registered.multiple.times", new Object[]{reference}));
                return null;
            }
            this.persistenceUnits.put(unitName, reference);
            register = this.persistenceContextDefinitions.containsKey(unitName);
        }
        if (register) {
            this.registerEM(unitName);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference ref, Object o) {
        String unitName;
        if (_logger.isDebugEnabled()) {
            _logger.debug("A managed persistence unit, {}, has been unregistered.", new Object[]{ref});
        }
        if ((unitName = (String)ref.getProperty("osgi.unit.name")) == null) {
            unitName = "";
        }
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            this.persistenceUnits.remove(unitName);
        }
        this.unregisterEM(unitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContext(String name, Bundle client, HashMap<String, Object> properties) {
        boolean register;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Registering bundle {} as a client of persistence unit {} with properties {}.", new Object[]{client.getSymbolicName() + "_" + client.getVersion(), name, properties});
        }
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            Set<Bundle> bundles = this.persistenceContextConsumers.get(name);
            if (bundles == null) {
                bundles = new HashSet<Bundle>();
                this.persistenceContextConsumers.put(name, bundles);
            }
            bundles.add(client);
            HashMap<String, Object> oldProps = this.persistenceContextDefinitions.put(name, properties);
            if (oldProps != null && !oldProps.equals(properties)) {
                _logger.warn(NLS.MESSAGES.getMessage("persistence.context.exists.multiple.times", new Object[]{client.getSymbolicName(), client.getVersion(), name, properties, oldProps}));
                this.persistenceContextDefinitions.put(name, oldProps);
            }
            register = this.persistenceUnits.containsKey(name);
        }
        if (register) {
            this.registerEM(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContext(String name, Bundle client) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Unregistering the bundle {} as a client of persistence unit {}.", new Object[]{client.getSymbolicName() + "_" + client.getVersion(), name});
        }
        boolean unregister = false;
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            Set<Bundle> clients = this.persistenceContextConsumers.get(name);
            clients.remove(client);
            if (clients.isEmpty()) {
                this.persistenceContextDefinitions.remove(name);
                this.persistenceContextConsumers.remove(name);
                unregister = true;
            }
        }
        if (unregister) {
            this.unregisterEM(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void registerEM(String name) {
        boolean alreadyRegistered;
        ServiceRegistration reg;
        block37: {
            boolean recoverFromLiveLock;
            reg = null;
            alreadyRegistered = false;
            try {
                PersistenceContextManager persistenceContextManager = this;
                // MONITORENTER : persistenceContextManager
                if (!this.entityManagerRegistrations.containsKey(name)) break block37;
                alreadyRegistered = true;
                // MONITOREXIT : persistenceContextManager
                recoverFromLiveLock = false;
                PersistenceContextManager persistenceContextManager2 = this;
            }
            catch (Throwable throwable) {
                boolean recoverFromLiveLock2 = false;
                PersistenceContextManager persistenceContextManager = this;
                // MONITORENTER : persistenceContextManager
                if (reg != null) {
                    if (this.entityManagerRegistrations.containsKey(name)) {
                        this.entityManagerRegistrations.put(name, reg);
                    } else {
                        _logger.warn(NLS.MESSAGES.getMessage("possible.livelock.recovery", new Object[]{name}));
                        this.entityManagerRegistrations.remove(name);
                        recoverFromLiveLock2 = true;
                    }
                } else if (!alreadyRegistered) {
                    this.entityManagerRegistrations.remove(name);
                }
                ((Object)((Object)this)).notifyAll();
                // MONITOREXIT : persistenceContextManager
                if (!recoverFromLiveLock2) throw throwable;
                AriesFrameworkUtil.safeUnregisterService(reg);
                throw throwable;
            }
            if (reg != null) {
                if (this.entityManagerRegistrations.containsKey(name)) {
                    this.entityManagerRegistrations.put(name, reg);
                } else {
                    _logger.warn(NLS.MESSAGES.getMessage("possible.livelock.recovery", new Object[]{name}));
                    this.entityManagerRegistrations.remove(name);
                    recoverFromLiveLock = true;
                }
            } else if (!alreadyRegistered) {
                this.entityManagerRegistrations.remove(name);
            }
            ((Object)((Object)this)).notifyAll();
            // MONITOREXIT : persistenceContextManager2
            if (!recoverFromLiveLock) return;
            AriesFrameworkUtil.safeUnregisterService(reg);
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Registering a managed persistence context for persistence unit {}", new Object[]{name});
        }
        this.entityManagerRegistrations.put(name, null);
        ServiceReference unit = this.persistenceUnits.get(name);
        Map props = this.persistenceContextDefinitions.get(name);
        if (props == null || unit == null) {
            _logger.error(NLS.MESSAGES.getMessage("null.pu.or.props", new Object[]{name, unit, props}));
            // MONITOREXIT : persistenceContextManager
            boolean recoverFromLiveLock = false;
            PersistenceContextManager persistenceContextManager = this;
            // MONITORENTER : persistenceContextManager
            if (reg != null) {
                if (this.entityManagerRegistrations.containsKey(name)) {
                    this.entityManagerRegistrations.put(name, reg);
                } else {
                    _logger.warn(NLS.MESSAGES.getMessage("possible.livelock.recovery", new Object[]{name}));
                    this.entityManagerRegistrations.remove(name);
                    recoverFromLiveLock = true;
                }
            } else if (!alreadyRegistered) {
                this.entityManagerRegistrations.remove(name);
            }
            ((Object)((Object)this)).notifyAll();
            // MONITOREXIT : persistenceContextManager
            if (!recoverFromLiveLock) return;
            AriesFrameworkUtil.safeUnregisterService(reg);
            return;
        }
        ManagedPersistenceContextFactory entityManagerServiceFactory = new ManagedPersistenceContextFactory(name, unit, props, this.persistenceContextRegistry);
        // MONITOREXIT : persistenceContextManager
        Hashtable<String, Object> props2 = new Hashtable<String, Object>();
        props2.put("osgi.unit.name", name);
        props2.put("osgi.unit.version", unit.getProperty("osgi.unit.version"));
        props2.put("org.apache.aries.jpa.container.managed", Boolean.TRUE);
        props2.put("osgi.unit.provider", unit.getProperty("osgi.unit.provider"));
        props2.put("org.apache.aries.jpa.default.unit.name", "".equals(name));
        props2.put("org.apache.aries.jpa.proxy.factory", "true");
        BundleContext persistenceBundleContext = unit.getBundle().getBundleContext();
        reg = persistenceBundleContext.registerService(EntityManagerFactory.class.getName(), (Object)entityManagerServiceFactory, props2);
        boolean recoverFromLiveLock = false;
        PersistenceContextManager persistenceContextManager = this;
        if (reg != null) {
            if (this.entityManagerRegistrations.containsKey(name)) {
                this.entityManagerRegistrations.put(name, reg);
            } else {
                _logger.warn(NLS.MESSAGES.getMessage("possible.livelock.recovery", new Object[]{name}));
                this.entityManagerRegistrations.remove(name);
                recoverFromLiveLock = true;
            }
        } else if (!alreadyRegistered) {
            this.entityManagerRegistrations.remove(name);
        }
        ((Object)((Object)this)).notifyAll();
        // MONITOREXIT : persistenceContextManager
        if (!recoverFromLiveLock) return;
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEM(String unitName) {
        ServiceRegistration reg = null;
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            boolean found = false;
            for (int tries = 0; !found && tries < 4; ++tries) {
                if (!this.entityManagerRegistrations.containsKey(unitName)) {
                    return;
                }
                reg = this.entityManagerRegistrations.get(unitName);
                if (reg != null) {
                    found = true;
                    this.entityManagerRegistrations.remove(unitName);
                    continue;
                }
                try {
                    ((Object)((Object)this)).wait(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    _logger.warn(NLS.MESSAGES.getMessage("interruption.waiting.for.pu.unregister", new Object[]{unitName}));
                }
            }
            if (!found) {
                this.entityManagerRegistrations.remove(unitName);
                _logger.warn(NLS.MESSAGES.getMessage("possible.livelock.detected", new Object[]{unitName}));
            }
        }
        if (reg != null) {
            AriesFrameworkUtil.safeUnregisterService(reg);
        }
    }

    public void open() {
        super.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceUnits(Bundle bundleToQuiesce, DestroyCallback callback) {
        Object it;
        ArrayList<String> units = new ArrayList<String>();
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            it = this.persistenceUnits.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ServiceReference> entry = it.next();
                ServiceReference value = entry.getValue();
                if (!value.getBundle().equals(bundleToQuiesce)) continue;
                units.add(entry.getKey());
                this.context.ungetService(entry.getValue());
                it.remove();
            }
        }
        if (units.isEmpty()) {
            callback.callback();
        } else {
            ArrayList<ManagedPersistenceContextFactory> factoriesToQuiesce = new ArrayList<ManagedPersistenceContextFactory>();
            it = this;
            synchronized (it) {
                Iterator it2 = units.iterator();
                while (it2.hasNext()) {
                    ManagedPersistenceContextFactory fact;
                    ServiceRegistration reg = this.entityManagerRegistrations.get(it2.next());
                    boolean needsQuiesce = false;
                    if (reg != null && (fact = (ManagedPersistenceContextFactory)bundleToQuiesce.getBundleContext().getService(reg.getReference())) != null) {
                        factoriesToQuiesce.add(fact);
                        needsQuiesce = true;
                    }
                    if (needsQuiesce) continue;
                    it2.remove();
                }
            }
            if (factoriesToQuiesce.isEmpty()) {
                callback.callback();
            } else {
                QuiesceTidyUp tidyUp = new QuiesceTidyUp(units, callback);
                for (ManagedPersistenceContextFactory fact : factoriesToQuiesce) {
                    fact.quiesce(tidyUp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceAllUnits(DestroyCallback callback) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ServiceRegistration> factoriesToQuiesce = new ArrayList<ServiceRegistration>();
        PersistenceContextManager persistenceContextManager = this;
        synchronized (persistenceContextManager) {
            names.addAll(this.entityManagerRegistrations.keySet());
            factoriesToQuiesce.addAll(this.entityManagerRegistrations.values());
        }
        if (names.isEmpty() || factoriesToQuiesce.isEmpty()) {
            callback.callback();
        } else {
            QuiesceTidyUp tidyUp = new QuiesceTidyUp(names, callback);
            for (ServiceRegistration reg : factoriesToQuiesce) {
                ManagedPersistenceContextFactory fact = (ManagedPersistenceContextFactory)reg.getReference().getBundle().getBundleContext().getService(reg.getReference());
                fact.quiesce(tidyUp);
            }
        }
    }

    static {
        Filter f = null;
        String filterString = "(&(objectClass=javax.persistence.EntityManagerFactory)(org.apache.aries.jpa.container.managed=true)(!(org.apache.aries.jpa.proxy.factory=*)))";
        try {
            f = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            _logger.error(NLS.MESSAGES.getMessage("emf.filter.invalid", new Object[]{filterString}), (Throwable)e);
            throw new RuntimeException(e);
        }
        filter = f;
    }

    class QuiesceTidyUp {
        private final Set<String> units;
        private final DestroyCallback dc;

        public QuiesceTidyUp(Collection<String> units, DestroyCallback callback) {
            this.units = new HashSet<String>(units);
            this.dc = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unitQuiesced(String name) {
            boolean winner;
            PersistenceContextManager.this.unregisterEM(name);
            QuiesceTidyUp quiesceTidyUp = this;
            synchronized (quiesceTidyUp) {
                winner = !this.units.isEmpty() && this.units.remove(name) && this.units.isEmpty();
            }
            if (winner) {
                this.dc.callback();
            }
        }
    }
}

